/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMCommandSender;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

class ControlledSubsystem {
    private static final Logger LOG = Logger.getLogger(ControlledSubsystem.class.getName());
    protected final MCMConfig config;
    protected final MCMCommandSender commandSender;
    protected final CCS ccs;
    private final String targetSubsystem;
    private final AgentLockService agentLockService;
    private final AlertService alertService;
    private final Alert goneAlert;
    private final Alert faultAlert;
    private final Alert lockAlert;
    private final Subsystem mcm;
    private volatile AgentLock targetLock;

    public ControlledSubsystem(Subsystem mcm, final String targetSubsystem, CCS ccs, MCMConfig config) {
        this.config = config;
        this.mcm = mcm;
        this.agentLockService = (AgentLockService)mcm.getAgentService(AgentLockService.class);
        this.alertService = (AlertService)mcm.getAgentService(AlertService.class);
        String goneAlertId = targetSubsystem + "_gone";
        this.goneAlert = new Alert(goneAlertId, "Alert raised when controlled subsystem disappears.");
        this.alertService.registerAlert(this.goneAlert);
        String faultAlertId = targetSubsystem + "_fault";
        this.faultAlert = new Alert(faultAlertId, "Alert raised when controlled subsystem goes into fault state.");
        this.alertService.registerAlert(this.faultAlert);
        String lockAlertId = targetSubsystem + "_lock";
        this.lockAlert = new Alert(lockAlertId, "Alert raised when a lock on a controlled subsystem is lost.");
        this.alertService.registerAlert(this.lockAlert);
        this.commandSender = new MCMCommandSender(targetSubsystem, mcm.getMessagingAccess());
        this.ccs = ccs;
        this.targetSubsystem = targetSubsystem;
        mcm.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (AgentInfo agent : agents) {
                    if (!agent.getName().equals(targetSubsystem)) continue;
                    try {
                        StateBundle initialState = ControlledSubsystem.this.commandSender.sendCommand(StateBundle.class, "getState", new Object[0]);
                        ControlledSubsystem.this.alertService.raiseAlert(ControlledSubsystem.this.goneAlert, AlertState.NOMINAL, String.format("Controlled subsystem %s has connected", targetSubsystem), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
                        ControlledSubsystem.this.onConnect(agent, initialState);
                    }
                    catch (ExecutionException x) {
                        LOG.log(Level.SEVERE, "Failed to get initial state from subsystem " + targetSubsystem, x);
                    }
                }
            }

            public void disconnected(AgentInfo ... agents) {
                for (AgentInfo agent : agents) {
                    if (!agent.getName().equals(targetSubsystem)) continue;
                    if (ControlledSubsystem.this.agentLockService.getExistingLockForAgent(targetSubsystem) != null) {
                        ControlledSubsystem.this.alertService.raiseAlert(ControlledSubsystem.this.goneAlert, AlertState.ALARM, String.format("Controlled subsystem %s has disconnected", targetSubsystem), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
                    }
                    ControlledSubsystem.this.onDisconnect(agent);
                }
            }
        });
        Predicate targetSubsystemFilter = BusMessageFilterFactory.messageOrigin((String)targetSubsystem);
        mcm.getMessagingAccess().addStatusMessageListener(msg -> {
            if (msg instanceof StatusStateChangeNotification) {
                StatusStateChangeNotification scn = (StatusStateChangeNotification)msg;
                boolean isInFault = scn.getNewState().isInState((Enum)OperationalState.ENGINEERING_FAULT);
                if (isInFault && this.targetLock != null) {
                    String cause = scn.getCause();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Controlled subsystem ").append(targetSubsystem).append(" has gone into FAULT.");
                    if (cause != null) {
                        sb.append(" Cause: ").append(cause);
                    }
                    this.alertService.raiseAlert(this.faultAlert, AlertState.ALARM, sb.toString());
                    try {
                        this.unlock();
                    }
                    catch (ExecutionException x) {
                        LOG.log(Level.WARNING, "Error while unlocking " + targetSubsystem + " after fault", x.getCause());
                    }
                } else if (!isInFault) {
                    this.alertService.raiseAlert(this.faultAlert, AlertState.NOMINAL, String.format("Controlled subsystem %s is no longer in FAULT", targetSubsystem), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
                }
                this.onStateChange(scn);
            } else if (!(msg instanceof StatusHeartBeat)) {
                this.onEvent(msg);
            }
        }, targetSubsystemFilter);
        ((AgentLockService)mcm.getAgentService(AgentLockService.class)).addAgentLockUpdateListener(new AgentLockService.AgentLockUpdateListener(){

            public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
                if (agentName.equals(targetSubsystem) && ControlledSubsystem.this.targetLock != null) {
                    if (lock == null) {
                        ControlledSubsystem.this.alertService.raiseAlert(ControlledSubsystem.this.lockAlert, AlertState.ALARM, String.format("Lost lock on controlled subsystem %s", targetSubsystem));
                    } else {
                        ControlledSubsystem.this.alertService.raiseAlert(ControlledSubsystem.this.lockAlert, AlertState.NOMINAL, String.format("Controlled subsystem %s is now locked", targetSubsystem), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
                    }
                    LOG.log(Level.INFO, "Held Lock Update: {0}", ControlledSubsystem.asString(lock));
                }
            }

            public void onGlobalLockUpdate(String agentName, String owner, AgentLock lock) {
                if (agentName.equals(targetSubsystem)) {
                    LOG.log(Level.INFO, "Global Lock Update: {0}", ControlledSubsystem.asString(lock));
                    try {
                        AgentLockInfo theLock = (AgentLockInfo)lock;
                        if (theLock.getStatus() == AgentLockInfo.Status.RELEASED) {
                            this.onAgentHeldLockUpdate(agentName, null);
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }

            public void onAgentLevelChange(String agentName, int level) {
            }
        });
    }

    public AgentLock lockAndSwitchToNormal(int level) throws ExecutionException {
        try {
            LOG.log(Level.INFO, "Locking agent {0}", this.targetSubsystem);
            this.agentLockService.setLevelForAgent(this.targetSubsystem, level);
            this.targetLock = this.agentLockService.getLockForAgent(this.targetSubsystem);
            if (this.targetLock == null) {
                throw new UnauthorizedLockException("setLevelForAgent(...) succeeded yet there is no held lock");
            }
            try {
                this.commandSender.sendCommand("switchToNormalMode", new Object[0]);
            }
            catch (ExecutionException x) {
                this.targetLock = null;
                this.agentLockService.unlockAgent(this.targetSubsystem);
                throw x;
            }
            return this.targetLock;
        }
        catch (RuntimeException | UnauthorizedLevelException | UnauthorizedLockException x) {
            throw new ExecutionException("Failed to lock subsystem " + this.targetSubsystem, x);
        }
    }

    public void unlock() throws ExecutionException {
        block2: {
            this.targetLock = null;
            this.alertService.raiseAlert(this.lockAlert, AlertState.NOMINAL, String.format("Controlled subsystem %s is no longer expected to be locked", this.targetSubsystem), AlertService.RaiseAlertStrategy.ON_SEVERITY_CHANGE);
            try {
                this.agentLockService.unlockAgent(this.targetSubsystem);
            }
            catch (RuntimeException | UnauthorizedLockException x) {
                if (this.agentLockService.getLockForAgent(this.targetSubsystem) == null) break block2;
                throw new ExecutionException("Failed to unlock subsystem " + this.targetSubsystem, x);
            }
        }
    }

    public void start(String configName) throws ExecutionException {
        this.commandSender.sendCommand("publishConfigurationInfo", new Object[0]);
    }

    protected void onConnect(AgentInfo agent, StateBundle initialState) {
    }

    protected void onDisconnect(AgentInfo agent) {
    }

    protected void onStateChange(StatusStateChangeNotification statusChange) {
    }

    protected void onEvent(StatusMessage msg) {
    }

    String getAgentName() {
        return this.targetSubsystem;
    }

    AgentLock getLock() {
        return this.targetLock;
    }

    void sendEvent(String key, Serializable object) {
        KeyValueData kvd = new KeyValueData(key, object);
        this.mcm.publishSubsystemDataOnStatusBus(kvd);
        LOG.log(Level.INFO, "Sent: {0}", object);
    }

    private static String asString(AgentLock lock) {
        if (lock == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[Agent: ").append(lock.getAgentName()).append(", owner: ").append(lock.getOwner());
        try {
            AgentLockInfo theLock = (AgentLockInfo)lock;
            sb.append(", ").append(theLock.getStatus());
            sb.append(", current: ").append(theLock.getCurrentAgent()).append(", origin: ").append(theLock.getOriginatingAgent());
        }
        catch (ClassCastException x) {
            sb.append(", class: ").append(lock.getClass().getName());
        }
        return sb.append("]").toString();
    }
}

