/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.AuxTelTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.CameraTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.ComCamTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.OCSTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.config.Device;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.sal.camera.CameraTelemetry;

public abstract class TelemetrySender {
    private static final Duration PARTIAL_DATA_TIMEOUT = Duration.ofSeconds(10L);
    private static final Logger LOG = Logger.getLogger(TelemetrySender.class.getName());
    private final Map<String, PartialData> partialDataMap = new ConcurrentHashMap<String, PartialData>();
    private final ScheduledExecutorService scheduler;
    private OCSTelemetrySender sender;

    static TelemetrySender create(Device device, OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        switch (device) {
            case COMCAM: {
                return new ComCamTelemetrySender(sender, scheduler);
            }
            case AUXTEL: {
                return new AuxTelTelemetrySender(sender, scheduler);
            }
            case CAMERA: {
                return new CameraTelemetrySender(sender, scheduler);
            }
        }
        throw new IllegalArgumentException("Unsupported device: " + device);
    }

    protected TelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
        this.sender = sender;
    }

    abstract GenericConverter getConverter();

    void send(Map<String, SALClassDescription> salClassMapInfo, StatusSubsystemData data) {
        this.handlePartialTelemetry(salClassMapInfo, data);
    }

    private void convertAndSend(Map<String, SALClassDescription> salClassMapInfo, StatusSubsystemData data) {
        try {
            List<CameraTelemetry> converted = this.getConverter().telemetryConverter(salClassMapInfo, data);
            if (converted.isEmpty()) {
                LOG.log(Level.FINE, "No converted data {0}", data.getOriginAgentInfo().getName());
            } else {
                for (CameraTelemetry t : converted) {
                    t = this.applyAfterBurner(t);
                    LOG.log(Level.FINE, "Sending {0} {1}", new Object[]{data.getOriginAgentInfo().getName(), t});
                    this.sender.sendTelemetry(t);
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(Level.WARNING, String.format("Problem converting telemetry subsytem: %s key: %s", data.getOriginAgentInfo().getName(), data.getDataKey()));
        }
    }

    protected CameraTelemetry applyAfterBurner(CameraTelemetry t) {
        return t;
    }

    private void handlePartialTelemetry(Map<String, SALClassDescription> salClassMapInfo, StatusSubsystemData data) {
        String name = data.getOriginAgentInfo().getName();
        KeyValueDataList kvdl = (KeyValueDataList)data.getSubsystemData();
        Serializable type = kvdl.getAttribute("publicationType");
        Serializable task = kvdl.getAttribute("taskName");
        Serializable total = kvdl.getAttribute("totalTasks");
        LOG.log(Level.FINE, "Name: {0}, type: {1}, task: {2}, total: {3}", new Object[]{name, type, task, total});
        if (type == null) {
            this.convertAndSend(salClassMapInfo, data);
        } else if ("scheduledFull".equals(type)) {
            this.convertAndSend(salClassMapInfo, data);
        } else if ("scheduledPartial".equals(type)) {
            PartialData dataSoFar = this.partialDataMap.computeIfAbsent(name, s -> new PartialData((String)s, salClassMapInfo, (Integer)total));
            dataSoFar.put(task.toString(), data);
            if (dataSoFar.isComplete()) {
                dataSoFar.send();
            }
        }
    }

    void setSender(OCSCommandExecutor ocs) {
        this.sender = ocs;
    }

    private class PartialData {
        private final Map<String, StatusSubsystemData> dataSoFar = new ConcurrentHashMap<String, StatusSubsystemData>();
        private final String subsystemName;
        private final int totalTasks;
        private final ScheduledFuture<?> timer;
        private final Map<String, SALClassDescription> salClasMapInfo;

        PartialData(String subsystemName, Map<String, SALClassDescription> salClassMapInfo, int totalTasks) {
            this.subsystemName = subsystemName;
            this.totalTasks = totalTasks;
            this.salClasMapInfo = salClassMapInfo;
            this.timer = TelemetrySender.this.scheduler.schedule(() -> this.send(), PARTIAL_DATA_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        }

        private void put(String taskName, StatusSubsystemData data) {
            this.dataSoFar.put(taskName, data);
        }

        private boolean isComplete() {
            return this.dataSoFar.size() == this.totalTasks;
        }

        private synchronized void send() {
            if (!this.timer.isDone()) {
                TelemetrySender.this.partialDataMap.remove(this.subsystemName);
                TelemetrySender.this.convertAndSend(this.salClasMapInfo, this.combineData(this.dataSoFar.values()));
            }
        }

        private StatusSubsystemData combineData(Collection<StatusSubsystemData> dataSoFar) {
            StatusSubsystemData result = null;
            for (StatusSubsystemData moreData : dataSoFar) {
                if (result == null) {
                    result = moreData;
                    continue;
                }
                KeyValueDataList kvdl = (KeyValueDataList)result.getSubsystemData();
                KeyValueDataList moreKVDL = (KeyValueDataList)moreData.getSubsystemData();
                for (KeyValueData kvd : moreKVDL.getListOfKeyValueData()) {
                    kvdl.addData(kvd);
                }
            }
            return result;
        }
    }
}

