/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class AggregateStatus {
    private final Map<Class<? extends Enum>, State> states = new LinkedHashMap<Class<? extends Enum>, State>();
    private final List<State.StateChangeListener<? extends Enum>> listeners = new CopyOnWriteArrayList<State.StateChangeListener<? extends Enum>>();
    private final List<FutureStatus> waiters = new CopyOnWriteArrayList<FutureStatus>();
    private final State.StateChangeListener internalStateChangeListener = new InternalStateChangeListener();

    public void add(CCSTimeStamp when, State<?> state) {
        State oldState = this.states.get(state.getEnumClass());
        if (oldState == null) {
            this.states.put(state.getEnumClass(), state);
            state.addStateChangeListener(this.internalStateChangeListener);
            this.notifyStateChanged(when, (Enum)state.getState(), null, null);
        } else {
            oldState.setState(when, state.getState());
        }
    }

    State get(Enum type) {
        return this.states.get(type.getDeclaringClass());
    }

    public boolean hasState(Enum ... statesToTest) {
        for (Enum e : statesToTest) {
            Class<?> enumClass = e.getClass();
            State state = this.states.get(enumClass);
            if (state != null && state.isInState(e)) continue;
            return false;
        }
        return true;
    }

    public boolean anyState(Enum ... statesToTest) {
        for (Enum e : statesToTest) {
            Class<?> enumClass = e.getClass();
            State state = this.states.get(enumClass);
            if (state == null || !state.isInState(e)) continue;
            return true;
        }
        return false;
    }

    public Collection<State> getStates() {
        return this.states.values();
    }

    <T extends Enum> void notifyStateChanged(CCSTimeStamp when, T currentState, T oldState, String cause) {
        for (State.StateChangeListener<? extends Enum> l : this.listeners) {
            l.stateChanged(when, currentState, oldState, cause);
        }
        for (FutureStatus waiter : this.waiters) {
            if (!this.hasState(waiter.state)) continue;
            waiter.complete(null);
        }
    }

    void addStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        this.listeners.add(listener);
    }

    void removeStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        this.listeners.remove(listener);
    }

    CompletableFuture<Void> waitForStatus(Enum state) {
        FutureStatus waiter = new FutureStatus(state);
        if (this.hasState(state)) {
            waiter.complete(null);
        } else {
            this.waiters.add(waiter);
        }
        return waiter;
    }

    public String toString() {
        return "AggregateStatus{states=" + this.states.values() + '}';
    }

    private class FutureStatus
    extends CompletableFuture<Void> {
        private final Enum state;

        FutureStatus(Enum state) {
            this.state = state;
        }
    }

    private class InternalStateChangeListener
    implements State.StateChangeListener {
        private InternalStateChangeListener() {
        }

        public void stateChanged(CCSTimeStamp when, Enum state, Enum oldState, String cause) {
            AggregateStatus.this.notifyStateChanged(when, state, oldState, cause);
        }
    }
}

