/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.util.ArrayList;
import java.util.stream.DoubleStream;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.fitting.SimpleCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;

public class ShutterMotionProfileFitter {
    double[] doFit(MotionDone md) {
        long startTime = md.startTime().getTAIInstant().toEpochMilli();
        double actualDuration = (double)md.actualDuration().getSeconds() + (double)md.actualDuration().getNano() * 1.0E-9;
        double endPosition = md.endPosition();
        double[] times_physical = DoubleStream.concat(md.hallTransitions().stream().mapToDouble(ht -> (double)(ht.getTime().getTAIInstant().toEpochMilli() - startTime) / 1000.0), DoubleStream.of(actualDuration)).toArray();
        double[] positions_physical = DoubleStream.concat(md.hallTransitions().stream().mapToDouble(ht -> ht.getPosition()), DoubleStream.of(endPosition)).toArray();
        int dataNumber = times_physical.length;
        double[] times_scaled = new double[dataNumber];
        double[] positions_scaled = new double[dataNumber];
        double startPosition = md.startPosition();
        String direction = "x";
        if (startPosition < endPosition) {
            direction = "+";
        } else if (startPosition > endPosition) {
            direction = "-";
        }
        for (int i = 0; i < dataNumber; ++i) {
            times_scaled[i] = times_physical[i] / actualDuration;
            if (direction.equals("+")) {
                positions_scaled[i] = (positions_physical[i] - startPosition) / 750.0;
                continue;
            }
            if (!direction.equals("-")) continue;
            positions_scaled[i] = (startPosition - positions_physical[i]) / 750.0;
        }
        ArrayList<WeightedObservedPoint> points = new ArrayList<WeightedObservedPoint>();
        SixParameterModel model = new SixParameterModel();
        double t0s = 0.0 / actualDuration;
        double t1s = 0.225 / actualDuration;
        double t2s = 0.675 / actualDuration;
        double j0s = 30000.0 * Math.pow(actualDuration, 3.0) / 750.0;
        double j1s = -30000.0 * Math.pow(actualDuration, 3.0) / 750.0;
        double j2s = 30000.0 * Math.pow(actualDuration, 3.0) / 750.0;
        double[] startPoint_scaled = new double[]{t0s, t1s, t2s, j0s, j1s, j2s};
        for (int i = 0; i < dataNumber; ++i) {
            points.add(new WeightedObservedPoint(1.0, times_scaled[i], positions_scaled[i]));
        }
        SimpleCurveFitter curveFitter = SimpleCurveFitter.create((ParametricUnivariateFunction)model, (double[])startPoint_scaled);
        double[] fit_scaled = curveFitter.fit(points);
        double[] fit_physical = new double[fit_scaled.length];
        fit_physical[0] = fit_scaled[0] * actualDuration;
        fit_physical[1] = fit_scaled[1] * actualDuration;
        fit_physical[2] = fit_scaled[2] * actualDuration;
        fit_physical[3] = fit_scaled[3] * 750.0 / Math.pow(actualDuration, 3.0);
        fit_physical[4] = fit_scaled[4] * 750.0 / Math.pow(actualDuration, 3.0);
        fit_physical[5] = fit_scaled[5] * 750.0 / Math.pow(actualDuration, 3.0);
        return fit_physical;
    }

    private static class SixParameterModel
    implements ParametricUnivariateFunction {
        private SixParameterModel() {
        }

        public double value(double t, double ... parameters) {
            double t0 = parameters[0];
            double t1 = parameters[1];
            double t2 = parameters[2];
            double j0 = parameters[3];
            double j1 = parameters[4];
            double j2 = parameters[5];
            if ((t -= t0) < t1) {
                return j0 * t * t * t / 6.0;
            }
            double A1 = (j0 - j1) * t1;
            double V1 = (j0 - j1) * t1 * t1 / 2.0 - A1 * t1;
            double S1 = (j0 - j1) * t1 * t1 * t1 / 6.0 - A1 * t1 * t1 / 2.0 - V1 * t1;
            if (t < t2) {
                return j1 * t * t * t / 6.0 + A1 * t * t / 2.0 + V1 * t + S1;
            }
            double A2 = A1 + (j1 - j2) * t2;
            double V2 = (j1 - j2) * t2 * t2 / 2.0 + (A1 - A2) * t2 + V1;
            double S2 = (j1 - j2) * t2 * t2 * t2 / 6.0 + (A1 - A2) * t2 * t2 / 2.0 + (V1 - V2) * t2 + S1;
            return j2 * t * t * t / 6.0 + A2 * t * t / 2.0 + V2 * t + S2;
        }

        public double[] gradient(double t, double ... parameters) {
            double delta = 0.001;
            double[] result = new double[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                double original = parameters[i];
                parameters[i] = original - delta;
                double v1 = this.value(t, parameters);
                parameters[i] = original + delta;
                double v2 = this.value(t, parameters);
                parameters[i] = original;
                result[i] = (v2 - v1) / (2.0 * delta);
            }
            return result;
        }
    }
}

