/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.sim.BonnShutterSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MainCameraShutterSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterSimulation;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Shutter {
    static final Duration MOVE_TIME = Duration.ofMillis(980L);
    private final MCMConfig config;
    private final State shutterReadinessState;
    private final State shutterState;
    private ShutterInterface shutter;
    private final CCS ccs;

    Shutter(CCS ccs, MCMConfig config) {
        this.ccs = ccs;
        this.config = config;
        this.shutterReadinessState = new State<ShutterReadinessState>(config.getShutterPrepTime() > 0.0 ? ShutterReadinessState.NOT_READY : ShutterReadinessState.READY);
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        ccs.getAggregateStatus().add(now, this.shutterReadinessState);
        this.shutterState = new State<ShutterState>(ShutterState.CLOSED);
        ccs.getAggregateStatus().add(now, this.shutterState);
        this.shutter = new ShutterSimulation(ccs, this.shutterState, config);
    }

    public void startImageSequence() {
        this.shutter.setImageSequence(true);
    }

    public void endImageSequence() {
        this.shutter.setImageSequence(false);
    }

    void prepare() {
        this.shutter.prepare();
    }

    void expose(ImageName imageName, Duration exposureTime) throws ExecutionException {
        this.shutterReadinessState.checkState(new Enum[]{ShutterReadinessState.READY});
        this.shutter.expose(imageName, exposureTime);
    }

    void start(String configName) throws ExecutionException {
        this.shutter.start(configName);
    }

    void open() throws ExecutionException {
        this.shutterReadinessState.checkState(new Enum[]{ShutterReadinessState.READY});
        this.shutter.open();
    }

    void close() throws ExecutionException {
        if (!this.shutterState.isInState(ShutterState.CLOSED)) {
            this.shutter.close();
        }
    }

    ControlledSubsystem registerMCMSubsystem(MCMSubsystem mcm) {
        this.shutter = this.config.getCameraType() == Camera.MAIN_CAMERA ? new MainCameraShutterSubsystemLayer(mcm, this.ccs, this.config) : new BonnShutterSubsystemLayer(mcm, this.ccs, this.config);
        return (ControlledSubsystem)((Object)this.shutter);
    }

    public static enum ShutterState {
        CLOSED,
        OPENING,
        OPEN,
        CLOSING;

    }

    public static enum ShutterReadinessState {
        NOT_READY,
        READY,
        GETTING_READY;

    }
}

