/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlaneInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class FocalPlaneSubsystemLayer
extends ControlledSubsystem
implements FocalPlaneInterface {
    private static final Logger LOG = Logger.getLogger(FocalPlaneSubsystemLayer.class.getName());
    private static final Map<Enum<FocalPlaneState>, Enum<FocalPlane.RaftsState>> FOCALPLANE_TO_RAFTS_STATE = new HashMap<Enum<FocalPlaneState>, Enum<FocalPlane.RaftsState>>();
    private volatile boolean initGuidersSucceeded;
    private volatile Duration estimatedGuidingTimePeriod;
    private volatile CompletableFuture<Integer> guidingFinished;

    FocalPlaneSubsystemLayer(MCMSubsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getFocalPlaneSubsystemName(), ccs, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endIntegration(boolean readout, Duration exposure) throws ExecutionException {
        HashMap<String, Double> meta = new HashMap<String, Double>();
        meta.put("ExposureTime", (double)exposure.toMillis() / 1000.0);
        this.commandSender.sendCommand("setHeaderKeywords", meta);
        try {
            this.waitForGuidingToFinish(this.guidingFinished);
        }
        finally {
            this.commandSender.sendCommand("endIntegration", new Object[0]);
        }
    }

    @Override
    public void startIntegration(ImageName imageName, Map<String, ? extends Serializable> parsedKeyValueData, Set locations, String annotation, Duration stopGuiding) throws ExecutionException {
        this.commandSender.sendCommand("setHeaderKeywords", parsedKeyValueData);
        this.guidingFinished = this.possiblyStartGuiding(imageName, stopGuiding, this.estimatedGuidingTimePeriod);
        this.commandSender.sendCommand("startNamedIntegration", imageName, annotation, locations);
    }

    private CompletableFuture<Integer> possiblyStartGuiding(ImageName imageName, Duration stopGuidingTime, Duration estimatedGuidingTimePeriod) throws ExecutionException {
        if (this.initGuidersSucceeded && stopGuidingTime != null) {
            CompletableFuture<Integer> guidersStopped = new CompletableFuture<Integer>();
            this.commandSender.sendCommand("startGuiding", imageName);
            LOG.log(Level.INFO, "Scheduling stopGuiding in {0} {1} {2}", new Object[]{stopGuidingTime, estimatedGuidingTimePeriod, stopGuidingTime.minus(estimatedGuidingTimePeriod)});
            this.ccs.schedule(stopGuidingTime.minus(estimatedGuidingTimePeriod), () -> {
                try {
                    int nStamps = this.commandSender.sendCommand(Integer.class, "stopGuiding", new Object[0]);
                    guidersStopped.complete(nStamps);
                }
                catch (ExecutionException x) {
                    guidersStopped.completeExceptionally(x.getCause());
                }
            });
            return guidersStopped;
        }
        return CompletableFuture.completedFuture(0);
    }

    private void waitForGuidingToFinish(CompletableFuture<Integer> guidingFinished) throws ExecutionException {
        if (guidingFinished != null) {
            try {
                long start = System.currentTimeMillis();
                int nStamps = guidingFinished.get(10L, TimeUnit.SECONDS);
                long stop = System.currentTimeMillis();
                LOG.log(Level.INFO, "Guiding finished after {0}ms and {1} stamps", new Object[]{stop - start, nStamps});
            }
            catch (ExecutionException x) {
                throw x;
            }
            catch (InterruptedException | TimeoutException x) {
                throw new ExecutionException("waitForGuiderToFinish did not complete", x);
            }
        }
    }

    @Override
    public void clear(int nClears) throws ExecutionException {
        this.commandSender.sendCommand("clear", nClears);
    }

    @Override
    public void clearAndStartIntegration(ImageName imageName, int nClears, Map<String, ? extends Serializable> parsedKeyValueData, Set locations, String annotation, Duration stopGuiding) throws ExecutionException {
        this.commandSender.sendCommand("setHeaderKeywords", parsedKeyValueData);
        this.guidingFinished = this.possiblyStartGuiding(imageName, stopGuiding, this.estimatedGuidingTimePeriod);
        this.commandSender.sendCommand("clearAndStartNamedIntegration", imageName, nClears, annotation, locations);
    }

    @Override
    public void discardRows(int nRows) throws ExecutionException {
        this.commandSender.sendCommand("shiftNRows", nRows);
    }

    @Override
    public void initGuiders(String roiSpec) throws ExecutionException {
        this.estimatedGuidingTimePeriod = Duration.ofMillis(this.commandSender.sendCommand(Integer.class, "initGuiders", roiSpec).intValue());
        this.initGuidersSucceeded = true;
    }

    @Override
    public void clearROI() throws ExecutionException {
        if (this.initGuidersSucceeded) {
            this.commandSender.sendCommand("clearROI", new Object[0]);
            this.initGuidersSucceeded = false;
        }
    }

    @Override
    public void setHeaderKeywords(Map<String, Serializable> headersMap) throws ExecutionException {
        this.commandSender.sendCommand("setHeaderKeywords", headersMap);
    }

    @Override
    public void play(String playlist, boolean repeat) throws ExecutionException {
        this.commandSender.sendCommand("play", playlist, repeat);
    }

    @Override
    public void definePlaylist(String playlist, String folder, String ... images) throws ExecutionException {
        this.commandSender.sendCommand("definePlaylist", playlist, folder, images);
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        CCSTimeStamp when = statusChange.getCCSTimeStamp();
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.translateFocalPlaneStateToRaftsState(when, (Enum)value));
    }

    @Override
    protected void onConnect(AgentInfo agent, StateBundle initialState) {
        LOG.info("Focal plane connected");
        FocalPlaneState state = (FocalPlaneState)initialState.getState(FocalPlaneState.class);
        this.translateFocalPlaneStateToRaftsState(CCSTimeStamp.currentTime(), (Enum)state);
    }

    @Override
    protected void onDisconnect(AgentInfo agent) {
        LOG.info("Focal plane disconnected");
    }

    private void translateFocalPlaneStateToRaftsState(CCSTimeStamp when, Enum value) {
        LOG.log(Level.INFO, "Got focal-plane state {0} ", value);
        Enum<FocalPlane.RaftsState> converted = FOCALPLANE_TO_RAFTS_STATE.get(value);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(when, new State<Enum<FocalPlane.RaftsState>>(converted));
        }
    }

    static {
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.NEEDS_CLEAR, FocalPlane.RaftsState.NEEDS_CLEAR);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.CLEARING, FocalPlane.RaftsState.CLEARING);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.INTEGRATING, FocalPlane.RaftsState.INTEGRATING);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.READING_OUT, FocalPlane.RaftsState.READING_OUT);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.QUIESCENT, FocalPlane.RaftsState.QUIESCENT);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.ROW_SHIFT, FocalPlane.RaftsState.DISCARDING);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.IMAGE_WAIT, FocalPlane.RaftsState.READING_OUT);
    }
}

