/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.ConfigurationAppliedEvent;
import org.lsst.sal.camera.event.ConfigurationsAvailableEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class InitGuidersTest
extends BridgeTest {
    @Test
    public void failTest() {
        try {
            this.ocsBridge.execute(new InitGuidersCommand("bollocks"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void initGuiders() {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(ConfigurationsAvailableEvent.class, AvailableFiltersEvent.class, ConfigurationAppliedEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.ocsBridge.execute(new InitGuidersCommand("bollocks"));
        Assert.assertEquals((long)2L, (long)tl.getCalls());
        tl.printFinalStates("InitAndTakeImageTest:initAndTakeEarly()");
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("InitAndTakeImageTest:initAndTakeEarly()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.executor.printEventList("InitAndTakeImageTest:initAndTakeEarly()");
    }
}

