package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.lsst.ccs.imagenaming.ImageName;

/**
 * Interface to be implemented by all shutters, simulated and real
 * @author tonyj
 */
public interface ShutterInterface {
    /**
     * Start and lock the shutter, with the specified configuration
     * @param configName 
     * @throws java.util.concurrent.ExecutionException 
     */
    void start(String configName) throws ExecutionException;
    
    void expose(ImageName imageName, Duration exposeTime) throws ExecutionException;

    void open() throws ExecutionException;

    void close() throws ExecutionException;

    /**
     * Get the shutter ready to move. If the shutter is always ready to move
     * this will be a NOOP.
     */
    void prepare();

    /**
     * Called if there are going to be a sequence of moves
     * @param imageSequence 
     */
    public void setImageSequence(boolean imageSequence);
}
