/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.drivers.ftdi.Ftdi;

public class TestModem {
    private static final PrintStream out = System.out;
    private final Ftdi ftd = new Ftdi();

    public static void main(String[] args) throws Exception {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser((Object)optns);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            out.println(e.getMessage());
            return;
        }
        new TestModem().run(optns);
        System.exit(0);
    }

    private void run(Options optns) throws Exception {
        this.ftd.open(optns.node, optns.index, optns.serial);
        this.ftd.setBaudrate(optns.baud);
        this.ftd.setDataCharacteristics(8, 0, 0);
        out.format("Modem status = %02x\n", this.ftd.getModemStatus());
        this.ftd.close();
    }

    private static class Options {
        @Option(name="-n", usage="node name")
        private String node;
        @Option(name="-s", usage="serial number")
        private String serial;
        @Option(name="-i", usage="device index")
        private int index = 0;
        @Option(name="-b", usage="baud rate")
        private int baud = 115200;

        private Options() {
        }
    }
}

