/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.scripting.ScriptingStatusBusListener;
import org.lsst.ccs.scripting.ScriptingStatusBusMessage;
import org.lsst.ccs.scripting.ScriptingStatusBusMessageFilter;
import org.lsst.ccs.scripting.ScriptingSubsystemWrapper;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class CCS {
    private static boolean shareLocksAcrossThreads = true;
    private static boolean throwExceptions = true;
    private static final Logger logger = Logger.getLogger((String)"org.lsst.ccs.scripting");
    private static final HashMap<Integer, ArrayList<ScriptingSubsystemWrapper>> subsystemsForThread = new HashMap();
    private static final HashMap<Integer, ArrayList<ScriptingStatusBusListenerWrapper>> listenersForThread = new HashMap();
    private static final Map<Integer, Set<String>> agentsLockedForThread = new HashMap<Integer, Set<String>>();
    private static ConcurrentMessagingUtils cmdUtils;
    private static ConcurrentHashMap<String, List<String>> attachedSubsystems;
    private static final Object agentsLockedLock;
    private static final AtomicInteger nextId;
    private static AgentMessagingLayer environmentAgent;
    private static Agent internalAgent;
    private static AgentLockService agentLockService;
    private static Duration defaultTimeout;
    private static final ThreadLocal<Integer> threadId;

    private CCS() {
    }

    private static ConcurrentMessagingUtils getMessagingAccessHelper() {
        if (cmdUtils == null) {
            cmdUtils = new ConcurrentMessagingUtils(CCS.getMessagingAccess());
        }
        return cmdUtils;
    }

    public static AgentMessagingLayer getMessagingAccess() {
        if (environmentAgent == null) {
            if (System.getProperty("org.lsst.ccs.testcontext", "false").equals("true")) {
                environmentAgent = CCS.getInternalMessagingAccess();
            } else {
                try {
                    logger.debug((Object)"getting environment messaging access");
                    environmentAgent = Agent.getEnvironmentMessagingAccess();
                    agentLockService = Agent.getEnvironmentLockService();
                }
                catch (Exception e) {
                    environmentAgent = CCS.getInternalMessagingAccess();
                }
            }
        }
        return environmentAgent;
    }

    private static AgentMessagingLayer getInternalMessagingAccess() {
        internalAgent = new Agent("CCSScriptingAgent", AgentInfo.AgentType.CONSOLE);
        internalAgent.startAgent();
        internalAgent.getMessagingAccess().getAgentPresenceManager().waitForFirstContact(3L, TimeUnit.SECONDS);
        agentLockService = internalAgent.getAgentService(AgentLockService.class);
        return internalAgent.getMessagingAccess();
    }

    public static List<AgentInfo> getAvailableAgents() {
        return CCS.getMessagingAccess().getAgentPresenceManager().listConnectedAgents();
    }

    public static void setDefaultTimeout(Duration timeout) {
        if (timeout.compareTo(Duration.ZERO) <= 0) {
            throw new IllegalArgumentException("The default timeout must be greater than zero");
        }
        defaultTimeout = timeout;
        for (ScriptingSubsystemWrapper wrapper : subsystemsForThread.get(threadId.get())) {
            wrapper.getConcurrentMessagingUtils().setDefaultTimeout(defaultTimeout);
        }
    }

    public static Duration getDefaultTimeoutDuration() {
        return defaultTimeout;
    }

    public static void setShareLocksAcrossThreads(boolean shareLocks) {
        shareLocksAcrossThreads = shareLocks;
    }

    public static void initializeScriptingEnvironment() {
        CCS.getMessagingAccess();
    }

    public static void shutdownScriptingEnvironment() throws Exception {
        CCS.cleanUp();
        if (internalAgent != null) {
            internalAgent.shutdownAgent();
        }
        environmentAgent = null;
    }

    public static void setThrowExceptions(boolean throwExceptions) {
        CCS.throwExceptions = throwExceptions;
    }

    public static boolean getThrowExceptions() {
        return throwExceptions;
    }

    public static ScriptingSubsystemWrapper attachSubsystem(String target) throws RuntimeException {
        try {
            return CCS.attachSubsystem(target, true);
        }
        catch (IOException | UnauthorizedLockException ex) {
            throw new RuntimeException("Error attaching to subsystem " + target, ex);
        }
    }

    public static ScriptingSubsystemWrapper attachSubsystem(String target, int level) throws Exception {
        ScriptingSubsystemWrapper wrapper = CCS.attachSubsystem(target, true);
        agentLockService.setLevelForAgent(target, level);
        return wrapper;
    }

    public static ScriptingSubsystemWrapper attachSubsystem(String target, boolean lock) throws UnauthorizedLockException, IOException {
        AgentMessagingLayer messagingAccess = CCS.getMessagingAccess();
        String agentName = target.contains("/") ? target.substring(0, target.indexOf("/")) : target;
        try {
            if (!messagingAccess.getAgentPresenceManager().waitForAgent(agentName, 5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("There is currently no subsystem with name \"" + agentName + "\" on the buses.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Error connecting to subsystem " + agentName, e);
        }
        if (lock) {
            if (!shareLocksAcrossThreads) {
                CCS.lockForThread(agentName);
            } else {
                CCS.lockOrAttachAgent(agentName);
            }
        }
        return CCS.doAttachSubsystem(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lockForThread(String agentName) throws UnauthorizedLockException, IOException {
        if (agentsLockedForThread.get(threadId.get()).contains(agentName)) {
            return;
        }
        Object object = agentsLockedLock;
        synchronized (object) {
            if (agentLockService.getLockForAgent(agentName) != null) {
                throw new RuntimeException("A local script already holds a lock on " + agentName + " or is acquiring it");
            }
            CCS.lockOrAttachAgent(agentName);
            agentsLockedForThread.get(threadId.get()).add(agentName);
        }
    }

    private static void lockOrAttachAgent(String agentName) throws UnauthorizedLockException, IOException {
        if (!agentLockService.getDetachableAgents().contains(agentName)) {
            try {
                agentLockService.setLevelForAgent(agentName, agentLockService.getLevelForAgent(agentName));
            }
            catch (UnauthorizedLevelException | UnauthorizedLockException x) {
                StringBuilder sb = new StringBuilder("Failed to lock ").append(agentName);
                AgentLock lock = agentLockService.getExistingLockForAgent(agentName);
                if (lock != null) {
                    sb.append(": locked by ").append(lock.getOwner());
                }
                throw new UnauthorizedLockException(sb.append(".").toString());
            }
        }
    }

    private static void unlockOrDetachAgent(String agentName) throws UnauthorizedLockException, IOException {
        if (agentLockService.getDetachableAgents().contains(agentName)) {
            agentLockService.detachLock(agentName);
        } else {
            agentLockService.unlockAgent(agentName);
        }
    }

    private static ScriptingSubsystemWrapper doAttachSubsystem(String target) {
        ConcurrentMessagingUtils concurrentMessagingUtils = new ConcurrentMessagingUtils(CCS.getMessagingAccess(), defaultTimeout);
        if (!target.contains("/") && !attachedSubsystems.contains(target)) {
            CommandRequest getDictionaryCommand = new CommandRequest(target, "getCommandTargets");
            try {
                List targets = (List)concurrentMessagingUtils.sendSynchronousCommand(getDictionaryCommand, Duration.ofMillis(10000L));
                attachedSubsystems.put(target, targets);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not fetch dictionary for subsystem " + target, e);
            }
        }
        ScriptingSubsystemWrapper wrapper = new ScriptingSubsystemWrapper(target, concurrentMessagingUtils);
        subsystemsForThread.get(threadId.get()).add(wrapper);
        logger.finest((Object)("Adding subsystem " + target + " to Thread " + threadId.get() + " for a total of " + subsystemsForThread.get(threadId.get()).size()));
        return wrapper;
    }

    public static void cleanUp() {
        ArrayList<ScriptingSubsystemWrapper> subsystems;
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(threadId.get());
        if (listeners != null) {
            for (ScriptingStatusBusListenerWrapper l : listeners) {
                CCS.cleanupListener(l);
            }
            listeners.clear();
        }
        if ((subsystems = subsystemsForThread.get(threadId.get())) != null) {
            subsystems.clear();
        }
        HashSet lockedAgentsLocal = new HashSet(agentsLockedForThread.get(threadId.get()));
        for (String agentToUnlock : lockedAgentsLocal) {
            try {
                CCS.unlockOrDetachAgent(agentToUnlock);
                agentsLockedForThread.get(threadId.get()).remove(agentToUnlock);
            }
            catch (IOException | UnauthorizedLockException ex) {
                logger.severe((Object)("cannot unlock agent " + agentToUnlock), (Throwable)ex);
            }
        }
        logger.finest((Object)("**** Cleaned up on ThreadLocal " + threadId.get()));
    }

    public static void addStatusBusListener(ScriptingStatusBusListener listener) {
        CCS.addStatusBusListener(listener, null);
    }

    public static void addStatusBusListener(ScriptingStatusBusListener listener, ScriptingStatusBusMessageFilter filter) {
        ScriptingStatusBusListenerWrapper busListener = new ScriptingStatusBusListenerWrapper(listener);
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(threadId.get());
        listeners.add(busListener);
        logger.finest((Object)("Adding listener to Thread " + threadId.get() + " for a total of " + listeners.size()));
        if (filter != null) {
            CCS.getMessagingAccess().addStatusMessageListener((StatusMessageListener)busListener, (Predicate)new ScriptingStatusBusMessageFilterWrapper(filter));
        } else {
            CCS.getMessagingAccess().addStatusMessageListener((StatusMessageListener)busListener);
        }
    }

    public static void removeStatusBusListener(ScriptingStatusBusListener listener) {
        CCS.removeStatusBusListener(listener, threadId.get());
    }

    private static void removeStatusBusListener(ScriptingStatusBusListener listener, Integer id) {
        ArrayList<ScriptingStatusBusListenerWrapper> listeners = listenersForThread.get(id);
        ScriptingStatusBusListenerWrapper toDelete = null;
        for (ScriptingStatusBusListenerWrapper l : listeners) {
            if (!l.getScriptingStatusBusListener().equals(listener)) continue;
            CCS.cleanupListener(l);
            toDelete = l;
            logger.finest((Object)("Removed listener on thread " + id + " for a total of " + listeners.size()));
            break;
        }
        if (toDelete != null) {
            listeners.remove(toDelete);
        } else {
            logger.warning((Object)("Could not remove listener " + listener + " on thread " + id));
        }
    }

    private static void cleanupListener(ScriptingStatusBusListenerWrapper listener) {
        CCS.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)listener);
    }

    public static Future<ScriptingStatusBusMessage> startListeningForStatusBusMessage(ScriptingStatusBusMessageFilter filter, Duration timeout) {
        Future future = CCS.getMessagingAccessHelper().startListeningForStatusBusMessage((Predicate)new ScriptingStatusBusMessageFilterWrapper(filter), timeout);
        return new FutureWrapper(future);
    }

    protected static List<String> getTargetsForSubsystem(String subsystemName) {
        return attachedSubsystems.get(subsystemName);
    }

    static {
        attachedSubsystems = new ConcurrentHashMap();
        agentsLockedLock = new Object();
        nextId = new AtomicInteger(0);
        environmentAgent = null;
        internalAgent = null;
        defaultTimeout = Duration.ofSeconds(3L);
        threadId = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                Integer id = nextId.getAndIncrement();
                subsystemsForThread.put(id, new ArrayList());
                listenersForThread.put(id, new ArrayList());
                agentsLockedForThread.put(id, new HashSet());
                return id;
            }
        };
    }

    static class ScriptingStatusBusListenerWrapper
    implements StatusMessageListener {
        private final ScriptingStatusBusListener scriptingListener;

        ScriptingStatusBusListenerWrapper(ScriptingStatusBusListener scriptingListener) {
            this.scriptingListener = scriptingListener;
        }

        public void onStatusMessage(StatusMessage s) {
            this.scriptingListener.onStatusBusMessage(new ScriptingStatusBusMessage(s));
        }

        protected ScriptingStatusBusListener getScriptingStatusBusListener() {
            return this.scriptingListener;
        }
    }

    static class ScriptingStatusBusMessageFilterWrapper
    implements Predicate<BusMessage<? extends Serializable, ?>> {
        private final ScriptingStatusBusMessageFilter filter;

        ScriptingStatusBusMessageFilterWrapper(ScriptingStatusBusMessageFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean test(BusMessage<? extends Serializable, ?> busMessage) {
            if (busMessage instanceof StatusMessage) {
                return this.filter.accept(new ScriptingStatusBusMessage((StatusMessage)busMessage));
            }
            return false;
        }
    }

    static class FutureWrapper
    implements Future<ScriptingStatusBusMessage> {
        private final Future<StatusMessage> future;

        public FutureWrapper(Future<StatusMessage> future) {
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public ScriptingStatusBusMessage get() throws InterruptedException, ExecutionException {
            StatusMessage msg = this.future.get();
            return new ScriptingStatusBusMessage(msg);
        }

        @Override
        public ScriptingStatusBusMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            StatusMessage msg = this.future.get(timeout, unit);
            return new ScriptingStatusBusMessage(msg);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }
    }
}

