package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

/**
 *
 * @author tonyj
 */
public class AuxTelConfigurationSender extends ConfigurationSender {

    private final GenericConverter converter;
    private final HashMap<String, Class> classMap;

    AuxTelConfigurationSender(OCSEventSender sender) {
        super(sender);

        Map<String, String> nameChange = new HashMap<>();

        List<String> subSystems = new ArrayList<>();
        subSystems.add("ats-fp");
        subSystems.add("ats-ih");
        subSystems.add("ats-daq-monitor");
        subSystems.add("ats");
        subSystems.add("ats-power");
        subSystems.add("bonn-shutter");

        classMap = new HashMap<>();

        classMap.put("ATCamera_logevent_ats-fp_Ccd_HardwareId", org.lsst.sal.atcamera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Ccd_Limits", org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Ccd_Rafts", org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_ImageDatabaseService_General", org.lsst.sal.atcamera.event.Focal_plane_ImageDatabaseService_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_ImageNameService_General", org.lsst.sal.atcamera.event.Focal_plane_ImageNameService_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_InstrumentConfig_Instrument", org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_PeriodicTasks_General", org.lsst.sal.atcamera.event.Focal_plane_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_PeriodicTasks_timers", org.lsst.sal.atcamera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Raft_HardwareId", org.lsst.sal.atcamera.event.Focal_plane_Raft_HardwareIdConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Raft_RaftTempControl", org.lsst.sal.atcamera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Raft_RaftTempControlStatus", org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_RebTotalPower_Limits", org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_Devices", org.lsst.sal.atcamera.event.Focal_plane_Reb_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_HardwareId", org.lsst.sal.atcamera.event.Focal_plane_Reb_HardwareIdConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_Limits", org.lsst.sal.atcamera.event.Focal_plane_Reb_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_Rafts", org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_RaftsLimits", org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_RaftsPower", org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_timers", org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_SequencerConfig_DAQ", org.lsst.sal.atcamera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_SequencerConfig_Sequencer", org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_WebHooksConfig_Visualization", org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent.class);

        classMap.put("ATCamera_logevent_ats-daq-monitor_PeriodicTasks_General", org.lsst.sal.atcamera.event.Daq_monitor_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_PeriodicTasks_timers", org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Stats_Statistics", org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Store", org.lsst.sal.atcamera.event.Daq_monitor_StoreConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Store_Devices", org.lsst.sal.atcamera.event.Daq_monitor_Store_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Store_Limits", org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Store_Store", org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent.class);

        classMap.put("ATCamera_logevent_ats-ih_ImageHandler_Commands", org.lsst.sal.atcamera.event.Image_handling_ImageHandler_CommandsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_ImageHandler_DAQ", org.lsst.sal.camera.event.Image_handling_ImageHandler_DAQConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_ImageHandler_FitsHandling", org.lsst.sal.atcamera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_PeriodicTasks_General", org.lsst.sal.camera.event.Image_handling_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_PeriodicTasks_timers", org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_Reb_FitsHandling", org.lsst.sal.camera.event.Image_handling_Reb_FitsHandlingConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_Reb_General", org.lsst.sal.atcamera.event.Image_handling_Reb_GeneralConfigurationEvent.class);

        classMap.put("ATCamera_logevent_bonn-shutter_Device_Devices", org.lsst.sal.atcamera.event.Bonn_shutter_Device_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_bonn-shutter_Device_General", org.lsst.sal.atcamera.event.Bonn_shutter_Device_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_bonn-shutter_Device_Limits", org.lsst.sal.atcamera.event.Bonn_shutter_Device_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_bonn-shutter_General", org.lsst.sal.atcamera.event.Bonn_shutter_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_bonn-shutter_PeriodicTasks_General", org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_bonn-shutter_PeriodicTasks_timers", org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_timersConfigurationEvent.class);

        classMap.put("ATCamera_logevent_ats-power_Analog_I_Limits", org.lsst.sal.atcamera.event.Ats_power_Analog_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Analog_V_Limits", org.lsst.sal.atcamera.event.Ats_power_Analog_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Aux_I_Limits", org.lsst.sal.atcamera.event.Ats_power_Aux_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Aux_V_Limits", org.lsst.sal.atcamera.event.Ats_power_Aux_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkHigh_I_Limits", org.lsst.sal.atcamera.event.Ats_power_ClkHigh_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkHigh_V_Limits", org.lsst.sal.atcamera.event.Ats_power_ClkHigh_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkLow_I_Limits", org.lsst.sal.atcamera.event.Ats_power_ClkLow_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkLow_V_Limits", org.lsst.sal.atcamera.event.Ats_power_ClkLow_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_DPHI_I_Limits", org.lsst.sal.atcamera.event.Ats_power_DPHI_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_DPHI_V_Limits", org.lsst.sal.atcamera.event.Ats_power_DPHI_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Digital_I_Limits", org.lsst.sal.atcamera.event.Ats_power_Digital_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Digital_V_Limits", org.lsst.sal.atcamera.event.Ats_power_Digital_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Fan_I_Limits", org.lsst.sal.atcamera.event.Ats_power_Fan_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Fan_V_Limits", org.lsst.sal.atcamera.event.Ats_power_Fan_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_HVBias_I_Limits", org.lsst.sal.atcamera.event.Ats_power_HVBias_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_HVBias_V_Limits", org.lsst.sal.atcamera.event.Ats_power_HVBias_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg1_Devices", org.lsst.sal.atcamera.event.Ats_power_Hameg1_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg1_Power", org.lsst.sal.atcamera.event.Ats_power_Hameg1_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg2_Devices", org.lsst.sal.atcamera.event.Ats_power_Hameg2_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg2_Power", org.lsst.sal.atcamera.event.Ats_power_Hameg2_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg3_Devices", org.lsst.sal.atcamera.event.Ats_power_Hameg3_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg3_Power", org.lsst.sal.atcamera.event.Ats_power_Hameg3_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Keithley_Devices", org.lsst.sal.atcamera.event.Ats_power_Keithley_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Keithley_Power", org.lsst.sal.atcamera.event.Ats_power_Keithley_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OD_I_Limits", org.lsst.sal.atcamera.event.Ats_power_OD_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OD_V_Limits", org.lsst.sal.atcamera.event.Ats_power_OD_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OTM_I_Limits", org.lsst.sal.atcamera.event.Ats_power_OTM_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OTM_V_Limits", org.lsst.sal.atcamera.event.Ats_power_OTM_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_PeriodicTasks_General", org.lsst.sal.atcamera.event.Ats_power_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_PeriodicTasks_timers", org.lsst.sal.atcamera.event.Ats_power_PeriodicTasks_timersConfigurationEvent.class);

        classMap.put("ATCamera_logevent_ats_CryoCon_Device", org.lsst.sal.atcamera.event.Ats_CryoCon_DeviceConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_CryoCon_Devices", org.lsst.sal.atcamera.event.Ats_CryoCon_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_PeriodicTasks_General", org.lsst.sal.atcamera.event.Ats_PeriodicTasks_GeneralConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_PeriodicTasks_timers", org.lsst.sal.atcamera.event.Ats_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_Pfeiffer_Device", org.lsst.sal.atcamera.event.Ats_Pfeiffer_DeviceConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_Pfeiffer_Devices", org.lsst.sal.atcamera.event.Ats_Pfeiffer_DevicesConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_TempCCDSetPoint_Limits", org.lsst.sal.atcamera.event.Ats_TempCCDSetPoint_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_TempCCD_Limits", org.lsst.sal.atcamera.event.Ats_TempCCD_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_TempColdPlate_Limits", org.lsst.sal.atcamera.event.Ats_TempColdPlate_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_TempCryoHead_Limits", org.lsst.sal.atcamera.event.Ats_TempCryoHead_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_Vacuum_Limits", org.lsst.sal.atcamera.event.Ats_Vacuum_LimitsConfigurationEvent.class);


        Mapping mapping = Mapping.defaultMapping();
        converter = new GenericConverter(subSystems, classMap, mapping, nameChange, Collections.EMPTY_MAP);
    }

    @Override
    GenericConverter getConverter() {
        return converter;
    }

    @Override
    String getConfigurationEvents() {
        return classMap.values().stream().map(c -> c.getSimpleName()).map(name -> name.replaceAll("Event$", "")).map(name -> SALClassDescriptionMaker.uncapitalize(name)).collect(Collectors.joining(","));
    }
}
