package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author tonyj
 */
public class TypeConverter {

    private static final Logger LOG = Logger.getLogger(TypeConverter.class.getName());

    private final Map<String, String> javaToXML = new HashMap<>();

    TypeConverter() {
        javaToXML.put("long", "long long");
        javaToXML.put("int", "long");
        javaToXML.put("boolean", "boolean");
        javaToXML.put("float", "float");
        javaToXML.put("double", "double");
        javaToXML.put("String", "string");
        javaToXML.put("java.lang.Integer", "long");
        javaToXML.put("java.lang.Long", "long long");
        javaToXML.put("java.lang.Double", "double");
        javaToXML.put("java.lang.Boolean", "boolean");
        javaToXML.put("java.lang.String", "string");
        javaToXML.put("java.time.Duration", "double");
    }

    String xmlType(String javaType) {
        if (javaType.endsWith("[]")) {
            javaType = javaType.substring(0, javaType.length() - 2);
        }
        String result = javaToXML.get(javaType);
        if (result != null) {
            return result;
        }
        LOG.log(Level.WARNING, "Unknown java type {0}", javaType);
        return "string";
    }
}
