/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.ErrorDialog;

abstract class SampThread
extends Thread {
    private final Component parent_;
    private final String errTitle_;
    private final String errText_;

    public SampThread(Component parent, String errTitle, String errText) {
        super("SAMP call");
        this.parent_ = parent;
        this.errTitle_ = errTitle;
        this.errText_ = errText;
    }

    public SampThread(EventObject evt, String errTitle, String errText) {
        this(evt.getSource() instanceof Component ? (Component)evt.getSource() : null, errTitle, errText);
    }

    protected abstract void sampRun() throws SampException;

    public void run() {
        try {
            this.sampRun();
        }
        catch (SampException e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ErrorDialog.showError(SampThread.this.parent_, SampThread.this.errTitle_, SampThread.this.errText_, e);
                }
            });
        }
    }
}

