/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.tile.operation;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.Buffer;
import java.util.Arrays;
import nom.tam.fits.FitsException;
import nom.tam.image.tile.operation.ITileOperation;
import nom.tam.image.tile.operation.ITileOperationInitialisation;
import nom.tam.image.tile.operation.ITiledImageOperation;
import nom.tam.image.tile.operation.TileArea;
import nom.tam.util.type.PrimitiveType;

public abstract class AbstractTiledImageOperation<OPERATION extends ITileOperation>
implements ITiledImageOperation {
    private int[] axes;
    private PrimitiveType<Buffer> baseType;
    private int[] tileAxes;
    private OPERATION[] tileOperations;
    private final Class<OPERATION> operationClass;

    public AbstractTiledImageOperation(Class<OPERATION> operationClass) {
        this.operationClass = operationClass;
    }

    @Override
    public PrimitiveType<Buffer> getBaseType() {
        return this.baseType;
    }

    public int getBufferSize() {
        int bufferSize = 1;
        for (int axisValue : this.axes) {
            bufferSize *= axisValue;
        }
        return bufferSize;
    }

    @Override
    public int getImageWidth() {
        return this.axes[0];
    }

    public OPERATION getTileOperation(int i) {
        return this.tileOperations[i];
    }

    public void setAxes(int[] axes) {
        this.axes = Arrays.copyOf(axes, axes.length);
    }

    public void setTileAxes(int[] value) throws FitsException {
        this.tileAxes = Arrays.copyOf(value, value.length);
        for (int index = 0; index < this.tileAxes.length; ++index) {
            if (this.tileAxes[index] > 0) continue;
            this.tileAxes[index] = this.axes[index];
        }
    }

    protected boolean areAxesUndefined() {
        return this.axes == null || this.axes.length == 0;
    }

    protected boolean areTileAxesUndefined() {
        return this.tileAxes == null || this.tileAxes.length == 0;
    }

    protected void createTiles(ITileOperationInitialisation<OPERATION> init) throws FitsException {
        int imageWidth = this.axes[0];
        int imageHeight = this.axes[1];
        int tileWidth = this.tileAxes[0];
        int tileHeight = this.tileAxes[1];
        int nrOfTilesOnXAxis = BigDecimal.valueOf((double)imageWidth / (double)tileWidth).setScale(0, RoundingMode.CEILING).intValue();
        int nrOfTilesOnYAxis = BigDecimal.valueOf((double)imageHeight / (double)tileHeight).setScale(0, RoundingMode.CEILING).intValue();
        int lastTileWidth = imageWidth - (nrOfTilesOnXAxis - 1) * tileWidth;
        int lastTileHeight = imageHeight - (nrOfTilesOnYAxis - 1) * tileHeight;
        int tileIndex = 0;
        ITileOperation[] operations = (ITileOperation[])Array.newInstance(this.operationClass, nrOfTilesOnXAxis * nrOfTilesOnYAxis);
        this.tileOperations = operations;
        init.tileCount(this.tileOperations.length);
        for (int y = 0; y < imageHeight; y += tileHeight) {
            boolean lastY = y + tileHeight >= imageHeight;
            for (int x = 0; x < imageWidth; x += tileWidth) {
                boolean lastX = x + tileWidth >= imageWidth;
                int dataOffset = y * imageWidth + x;
                OPERATION tileOperation = init.createTileOperation(tileIndex, new TileArea().start(x, y));
                tileOperation.setDimensions(dataOffset, lastX ? lastTileWidth : tileWidth, lastY ? lastTileHeight : tileHeight);
                this.tileOperations[tileIndex] = tileOperation;
                init.init(tileOperation);
                ++tileIndex;
            }
        }
    }

    protected int getNAxes() {
        return this.axes.length;
    }

    protected int getNumberOfTileOperations() {
        return this.tileOperations.length;
    }

    protected int[] getTileAxes() {
        return this.tileAxes;
    }

    protected OPERATION[] getTileOperations() {
        return this.tileOperations;
    }

    protected void setBaseType(PrimitiveType<Buffer> baseType) {
        this.baseType = baseType;
    }
}

