/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;

public class MCMLockHandler
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(MCMLockHandler.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private MCMSubsystem subsystem;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLoginService loginService;
    @ConfigurationParameter(description="Userid to be used to lock subsystems", isFinal=true)
    private final String userId = "mcm";
    private final Map<String, AgentLock> locks = new HashMap<String, AgentLock>();

    public void postStart() {
        this.loginService.login("mcm", "noCredentialsNeeded");
        Predicate stateChangeFilter = BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class);
    }

    @Command(type=Command.CommandType.ACTION, description="Attempt to lock all subsystems", level=0)
    public void lockAll() {
        ExecutionException lastException = null;
        for (ControlledSubsystem agent : this.subsystem.getControlledSubsystems()) {
            try {
                this.locks.put(agent.getAgentName(), agent.lockAndSwitchToNormal(0));
            }
            catch (ExecutionException x) {
                lastException = x;
                LOG.log(Level.WARNING, "Failed to lock or switch to normal mode for agent: " + agent, x);
            }
        }
        if (lastException != null) {
            throw new RuntimeException("At least one agent could not be locked, see log for details", lastException);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Show lock status of all syubsystems", level=0)
    public String showLocks() {
        ArrayList<String> result = new ArrayList<String>();
        for (ControlledSubsystem agent : this.subsystem.getControlledSubsystems()) {
            AgentLock lock = this.locks.get(agent.getAgentName());
            result.add(String.format("%s: %s", agent, lock == null ? "unlocked" : "locked"));
        }
        return result.stream().collect(Collectors.joining("\n"));
    }

    @Command(type=Command.CommandType.ACTION, description="Show lock status of all syubsystems", level=0)
    public void unlockAll() throws UnauthorizedLockException, IOException {
        Iterator<String> iter = this.locks.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            this.agentLockService.unlockAgent(key);
            iter.remove();
        }
    }
}

