/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlaneInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlaneSimulation;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlaneSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FocalPlane {
    private final CCS ccs;
    private FocalPlaneInterface focalPlane;
    private final State raftsState;
    private final MCMConfig config;
    static final Duration CLEAR_TIME = Duration.ofMillis(70L);
    static final Duration DISCARD_TIME = Duration.ofMillis(1L);
    static final Duration READOUT_TIME = Duration.ofMillis(2000L);

    FocalPlane(CCS ccs, MCMConfig config) {
        this.ccs = ccs;
        this.config = config;
        this.raftsState = new State<RaftsState>(RaftsState.NEEDS_CLEAR);
        ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), this.raftsState);
        this.focalPlane = new FocalPlaneSimulation(ccs, this.raftsState);
    }

    void clear(int nClears) throws ExecutionException {
        if (!this.config.isAlwaysClear()) {
            this.focalPlane.clear(nClears);
        }
    }

    void discardRows(int nRows) throws ExecutionException {
        this.focalPlane.discardRows(nRows);
    }

    void startIntegration(ImageName imageName, Map<String, String> parsedKeyValueData, LocationSet locations, String annotation) throws ExecutionException {
        if (this.config.isAlwaysClear()) {
            this.focalPlane.clearAndStartIntegration(imageName, 1, parsedKeyValueData, locations, annotation);
        } else {
            this.focalPlane.startIntegration(imageName, parsedKeyValueData, locations, annotation);
        }
    }

    void endIntegration(boolean readout, Duration exposure) throws ExecutionException {
        this.focalPlane.endIntegration(readout, exposure);
    }

    void play(String playlist, boolean repeat) throws ExecutionException {
        this.focalPlane.play(playlist, repeat);
    }

    void definePlaylist(String playlist, String folder, String[] images) throws ExecutionException {
        this.focalPlane.definePlaylist(playlist, folder, images);
    }

    void start(String configName) throws ExecutionException {
        this.focalPlane.start(configName);
    }

    ControlledSubsystem registerMCMSubsystem(MCMSubsystem mcm) {
        FocalPlaneSubsystemLayer controlledSubsystem = new FocalPlaneSubsystemLayer(mcm, this.ccs, this.config);
        this.focalPlane = controlledSubsystem;
        return controlledSubsystem;
    }

    public static enum RaftsState {
        NEEDS_CLEAR,
        CLEARING,
        INTEGRATING,
        READING_OUT,
        QUIESCENT,
        DISCARDING;

    }
}

