/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.sim.GenericConverterTest;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

public class SALClassDescriptionMakerTest {
    @Test
    public void makeSALClassDescriptionFromAuxTelRebPowerLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> info = SALClassDescriptionMakerTest.makeSALClassDescription("ats-power-status-dictionary.ser", 0, "ATCamera", "ats-power");
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("ATCamera_ats-power"));
    }

    @Test
    public void makeSALClassDescriptionFromMainCameraRebPowerLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> info = SALClassDescriptionMakerTest.makeSALClassDescription("rebpower-status-dictionary.ser", 0, "MTCamera", "rebpower");
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("MTCamera_rebpower"));
        SALClassDescription classDescription = info.values().iterator().next();
        Assert.assertEquals((long)2L, (long)classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).count());
        List locationVariableNames = classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).map(v -> v.getVariableName()).collect(Collectors.toList());
        Assert.assertTrue((boolean)locationVariableNames.contains("rebLocation"));
        Assert.assertTrue((boolean)locationVariableNames.contains("rebpsLocation"));
        List variables = classDescription.getVariables();
        Collections.sort(variables, (v1, v2) -> v1.getVariableName().compareTo(v2.getVariableName()));
        Assert.assertEquals((Object)classDescription.getVariables(), (Object)variables);
        CRC32 sum = new CRC32();
        classDescription.updateChecksum((Checksum)sum);
        Assert.assertEquals((long)3640498962L, (long)sum.getValue());
    }

    @Test
    public void makeSALClassDescriptionFromMainCameraFCSLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> info = SALClassDescriptionMakerTest.makeSALClassDescription("fcs-status-dictionary.ser", 0, "MTCamera", "fcs", "TRENDING", "trending");
        System.out.println(info);
    }

    @Test
    public void makeSALClassDescriptionFromMainCameraRebPowerLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> info = SALClassDescriptionMakerTest.makeSALClassDescription("rebpower-status-dictionary.ser", 1, "MTCamera", "rebpower");
        Assert.assertEquals((long)2L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("MTCamera_rebpower_Reb"));
        SALClassDescription classDescription = info.values().iterator().next();
        Assert.assertEquals((long)1L, (long)classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).count());
        List locationVariableNames = classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).map(v -> v.getVariableName()).collect(Collectors.toList());
        Assert.assertTrue((boolean)locationVariableNames.contains("location"));
        List variables = classDescription.getVariables();
        Collections.sort(variables, (v1, v2) -> v1.getVariableName().compareTo(v2.getVariableName()));
        Assert.assertEquals((Object)classDescription.getVariables(), (Object)variables);
        SALClassDescription desc = info.get("MTCamera_rebpower_Reb");
        SALClassDescription.SALVariable var = desc.getVariable("dphi_IbefLDO");
        Assert.assertEquals((long)8L, (long)var.getCount());
        Assert.assertEquals((long)71L, (long)desc.getSharedLocationCount(var));
        CRC32 sum = new CRC32();
        classDescription.updateChecksum((Checksum)sum);
        Assert.assertEquals((long)72957452L, (long)sum.getValue());
    }

    @Test
    public void makeSALClassDescriptionFromComCamFocalPlaneLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> info = SALClassDescriptionMakerTest.makeSALClassDescription("comcam-fp-status-dictionary.ser", 1, "CCCamera", "comcam-fp");
        Assert.assertEquals((long)4L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_comcam-fp_Reb"));
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_comcam-fp_Ccd"));
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_comcam-fp_Segment"));
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_comcam-fp_RebTotalPower"));
        SALClassDescription ccdDescription = info.get("CCCamera_comcam-fp_Ccd");
        Assert.assertEquals((long)1L, (long)ccdDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).count());
        SALClassDescription.SALVariable locationVariable = ccdDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).findAny().get();
        Assert.assertEquals((Object)"location", (Object)locationVariable.getVariableName());
        int count = ccdDescription.getSharedLocationCount(ccdDescription.getVariable("gDV"));
        Assert.assertEquals((long)9L, (long)count);
        CRC32 sum = new CRC32();
        ccdDescription.updateChecksum((Checksum)sum);
        Assert.assertEquals((long)711621509L, (long)sum.getValue());
    }

    public void makeSALClassDescriptionFromComcamDaqMonitorSettingsAppliedLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> infos = SALClassDescriptionMakerTest.makeSALClassDescription("comcam-daq-monitor-status-dictionary.ser", 0, "CCCamera", "daq-monitor", DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Assert.assertEquals((long)6L, (long)infos.size());
        Set categories = infos.values().stream().map(desc -> desc.getCategory()).collect(Collectors.toSet());
        Assert.assertEquals((long)6L, (long)categories.size());
        Assert.assertTrue((boolean)categories.contains("Store"));
        CRC32 sum = new CRC32();
        for (SALClassDescription info : infos.values()) {
            info.updateChecksum((Checksum)sum);
        }
        Assert.assertEquals((long)2519682352L, (long)sum.getValue());
    }

    public void makeSALClassDescriptionFromMainCameraRaftsSettingsAppliedLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> infos = SALClassDescriptionMakerTest.makeSALClassDescription("comcam-daq-monitor-status-dictionary.ser", 0, "CCCamera", "daq-monitor", DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Assert.assertEquals((long)6L, (long)infos.size());
        Set categories = infos.values().stream().map(desc -> desc.getCategory()).collect(Collectors.toSet());
        Assert.assertEquals((long)6L, (long)categories.size());
        Assert.assertTrue((boolean)categories.contains("Store"));
        CRC32 sum = new CRC32();
        for (SALClassDescription info : infos.values()) {
            info.updateChecksum((Checksum)sum);
        }
        Assert.assertEquals((long)2519682352L, (long)sum.getValue());
    }

    @Test
    public void makeSALClassDescriptionFromCamShutterStatusSettingsAppliedLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException {
        try {
            Map<String, SALClassDescription> map = SALClassDescriptionMakerTest.makeSALClassDescription("cam-shutter-status-dictionary.ser", 0, "MTCamera", "shutter", "TRENDING", "trending");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SALClassDescriptionMakerTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (TransformerException ex) {
            Logger.getLogger(SALClassDescriptionMakerTest.class.getName()).log(Level.SEVERE, null, ex);
        }
        Assert.assertEquals((long)1L, (long)1L);
    }

    public static Map<String, SALClassDescription> makeSALClassDescription(String file, int level, String cscName, String componentName) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        return SALClassDescriptionMakerTest.makeSALClassDescription(file, level, cscName, componentName, "MONITORING", "trending");
    }

    public static Map<String, SALClassDescription> makeSALClassDescription(String file, int level, String cscName, String componentName, String attributeType, String resultType) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Object readObject;
        String concat = "";
        try (InputStream in = GenericConverterTest.class.getResourceAsStream(file);){
            ObjectInputStream ois = new ObjectInputStream(in);
            Object object = null;
            try {
                readObject = ois.readObject();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ois != null) {
                    if (object != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ois.close();
                    }
                }
            }
        }
        Assert.assertTrue((boolean)(readObject instanceof StatusDataProviderDictionary));
        StatusDataProviderDictionary info = (StatusDataProviderDictionary)readObject;
        System.out.println(info);
        concat = concat + info.toString() + "\n";
        DataProviderDictionary dataProviderDictionary = info.getDataProviderDictionary();
        List dataProviderInfos = dataProviderDictionary.getDataProviderInfos();
        for (DataProviderInfo dpi : dataProviderInfos) {
            System.out.println(dpi);
            concat = concat + dpi.toString() + "\n";
        }
        BufferedReader inReader = new BufferedReader(new StringReader(concat));
        SALClassDescriptionMakerTest.processAndPrint(inReader);
        Mapping mapping = Mapping.defaultMapping();
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), cscName, componentName, level, mapping, attributeType, resultType);
        return maker.getSALClassDescriptions();
    }

    public static void processAndPrint(BufferedReader inReader) {
        String subsystem = "";
        System.out.println("");
        System.out.println(" **** Start Finding Paths with no Descriptions **** ");
        try {
            String line;
            while ((line = inReader.readLine()) != null) {
                if (line.startsWith("StatusDataProviderDictionary { origin=")) {
                    subsystem = line.replace("StatusDataProviderDictionary { origin=", " subsystem=");
                }
                if (!SALClassDescriptionMakerTest.conditions(line)) continue;
                line = line.replace("Path:", "Path: " + subsystem);
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(" **** End Finding Paths with no Descriptions **** ");
        System.out.println("");
    }

    public static boolean conditions(String line) {
        boolean pass = false;
        if (line.startsWith("Path:") && !line.contains("description") && !line.contains("config_category=Limits")) {
            pass = true;
        }
        return pass;
    }
}

