/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;

public class MappingTest {
    private Mapping mapping;

    @Before
    public void setup() {
        this.mapping = Mapping.defaultMapping();
        Assert.assertEquals((long)8L, (long)this.mapping.getPatternList().size());
    }

    @Test
    public void testLegacy() {
        Mapping.Match match = this.mapping.match("R22/Reb0/xyz");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"xyz", (Object)match.getPathAfterMatch());
        Assert.assertEquals((Object)"R22Reb0", (Object)match.getLocation());
        Assert.assertEquals((Object)"reb", (Object)match.getPatternName());
    }

    @Test
    public void testFlexible() {
        Mapping.Match match = this.mapping.match("periodicTasks/monitor-check/R22/Reb0/xyz");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"periodicTasks/monitor-check/xyz", (Object)match.getPathAfterMatch());
        Assert.assertEquals((Object)"R22Reb0", (Object)match.getLocation());
        Assert.assertEquals((Object)"reb", (Object)match.getPatternName());
    }

    @Test
    public void testCCD() {
        Mapping.Match match = this.mapping.match("R22/Reb1/S11/abcd");
        Assert.assertNotNull((Object)match);
        Assert.assertEquals((Object)"R22S11", (Object)match.getLocation());
        Assert.assertEquals((Object)"ccd", (Object)match.getPatternName());
        Assert.assertEquals((Object)"abcd", (Object)match.getPathAfterMatch());
    }
}

