/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Test;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMakerTest;

public class DeriveClassMapFromDictionaryTest {
    @Test
    public void mainTest() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> classDescriptions = SALClassDescriptionMakerTest.makeSALClassDescription("bonn-shutter-status-dictionary.ser", 1, "ATCamera", "bonn-shutter", DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        System.out.println(classDescriptions);
        System.out.println(classDescriptions.keySet());
        String[] packages = new String[]{"org.lsst.sal.atcamera.event", "org.lsst.sal.camera.event"};
        for (Map.Entry<String, SALClassDescription> entry : classDescriptions.entrySet()) {
            String className = entry.getKey();
            className = className.replace("ats-ih", "image-handling");
            className = className.replace("ats-fp", "focal-plane");
            className = className.replace("ats-daq-monitor", "daq-monitor");
            className = className.replace("comcam-ih", "image-handling");
            className = className.replace("comcam-fp", "focal-plane");
            className = className.replace("comcam-daq-monitor", "daq-monitor");
            className = className.replace("comcam-rebpower", "rebpower");
            className = className.replace("comcam-vacuum", "vacuum");
            className = className.replace("comcam-quadbox", "quadbox");
            className = className.replace("comcam-fcs", "fcs");
            className = className.replace("comcam-mpm", "mpm");
            className = className.replace("-", "_");
            className = className.replace("CCCamera_logevent_", "");
            className = className.replace("ATCamera_logevent_", "");
            className = SALClassDescriptionMaker.capitalize((String)className);
            className = className + "ConfigurationEvent";
            Class<?> classForName = null;
            for (String pkg : packages) {
                try {
                    classForName = Class.forName(pkg + "." + className);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (classForName == null) {
                System.out.println(className + " NOT FOUND");
                continue;
            }
            System.out.printf("classMap.put(\"%s\", %s.class);\n", entry.getKey(), classForName.getName());
        }
    }
}

