package org.lsst.ccs.subsystem.ocsbridge;

import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.CCSVersions;
import org.lsst.ccs.services.AgentVersionsService;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;

/**
 * Generates the software versions event for SAL
 *
 * @author tonyj
 */
class SoftwareVersionsGenerator {

    private final Agent agent;
    private final OCSBridge ocsBridge;

    SoftwareVersionsGenerator(OCSBridge ocsBridge, Agent agent) {
        this.ocsBridge = ocsBridge;
        this.agent = agent;
    }

    void run(boolean fullVersions) {
        AgentInfo agentInfo = agent.getAgentInfo();
        CCSVersions ccsVersions = agent.getAgentService(AgentVersionsService.class).getCCSVersions();
        String cscVersion = ccsVersions.getDistributionInfo(agentInfo).getVersion();
        String subsystemVersions = ccsVersions.getAgents().stream()
                .filter((a) -> a.isAgentWorkerOrService())
                .filter((a) -> !a.equals(agent.getAgentInfo()))
                .map((a) -> a.getName() + "=" + ccsVersions.getDistributionInfo(a).getVersion())
                .collect(Collectors.joining(","));
        OCSCommandExecutor oce = ocsBridge.getOcsCommandExecutor();
        SoftwareVersionsEvent sve = new SoftwareVersionsEvent(oce.getSALVersion(), oce.getXMLVersion(), oce.getOSPLVersion(), cscVersion, fullVersions ? subsystemVersions : "");

        ocsBridge.getOcsCommandExecutor().sendEvent(sve);
    }
}
