package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;

/**
 *
 * @author tonyj
 */
public class AuxTelTelemetrySender extends TelemetrySender {

    private final GenericConverter converter;

    public AuxTelTelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        super(sender, scheduler);
        // Map is what appears on the bus as key, on the right we have the argument 
        Map<String, String> nameChange = new HashMap<>();

        List<String> subSystems = new ArrayList<>();
        subSystems.add("ats-fp");
        subSystems.add("ats-daq-monitor");
        subSystems.add("ats");
        subSystems.add("ats-power");
        subSystems.add("bonn-shutter");

        Map<String, Class> classMap = new HashMap<>();

        classMap.put("ATCamera_ats-fp_Ccd", org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry.class);
        classMap.put("ATCamera_ats-fp_Reb", org.lsst.sal.atcamera.telemetry.Focal_plane_RebTelemetry.class);
        classMap.put("ATCamera_ats-fp_RebTotalPower", org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry.class);
        classMap.put("ATCamera_ats-fp_Segment", org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry.class);

        classMap.put("ATCamera_ats-daq-monitor_Store", Daq_monitor_StoreTelemetry.class);
        classMap.put("ATCamera_ats", org.lsst.sal.atcamera.telemetry.VacuumTelemetry.class);
        classMap.put("ATCamera_ats-power", org.lsst.sal.atcamera.telemetry.PowerTelemetry.class);
        classMap.put("ATCamera_bonn-shutter_Device", org.lsst.sal.atcamera.telemetry.Bonn_shutter_DeviceTelemetry.class);

        Mapping mapping = Mapping.defaultMapping();

        converter = new GenericConverter(subSystems, classMap, mapping, nameChange, Collections.EMPTY_MAP);
    }

    @Override
    protected CameraTelemetry applyAfterBurner(CameraTelemetry t) {
        // Fix for LCOBM-54, remove if LSSTCCSRAFTS-663 is ever fixed.
        if (t instanceof org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry) {
            org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry fct = (org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry) t;
            String location = fct.getLocation();
            if ("R00SW".equals(location)) {
                return new org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry(fct.getGDV(), "R00S00", fct.getODI(), fct.getODV(), fct.getOGV(), fct.getRDV(), fct.getTemp());
            } 
        }
        return t;
    }

    @Override
    GenericConverter getConverter() {
        return converter;
    }

}
