/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.events.EventListenerList;
import org.lsst.ccs.subsystem.ocsbridge.util.AggregateStatus;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

public class CCS {
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    private final CCSEvent.CCSEventListenerList eventListenerList = new CCSEvent.CCSEventListenerList();
    private final EventListenerList<StatusMessage> statusMessageListenerList = new EventListenerList();
    private static final Logger LOG = Logger.getLogger(CCS.class.getName());
    private final AggregateStatus as = new AggregateStatus();

    <T> ScheduledFuture<T> schedule(Duration when, Callable<T> callable) {
        return this.scheduler.schedule(callable, when.toMillis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(Duration when, Runnable runnable) {
        return this.scheduler.schedule(new RunnableWrapper(runnable), when.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void addStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        this.as.addStateChangeListener(listener);
    }

    public void removeStateChangeListener(State.StateChangeListener<? extends Enum> listener) {
        this.as.removeStateChangeListener(listener);
    }

    public void addEventListener(CCSEvent.CCSEventListener listener) {
        this.eventListenerList.addEventListener((EventListener)listener);
    }

    public void removeEventListener(CCSEvent.CCSEventListener listener) {
        this.eventListenerList.removeEventListener((EventListener)listener);
    }

    public void addStatusMessageListener(EventListener<StatusMessage> listener) {
        this.statusMessageListenerList.addEventListener(listener);
    }

    public void removeStatusMessageListener(EventListener<StatusMessage> listener) {
        this.statusMessageListenerList.removeEventListener(listener);
    }

    public void runInBackground(Runnable r) {
        this.scheduler.execute(r);
    }

    public void shutdown() throws InterruptedException {
        this.scheduler.shutdownNow();
        this.scheduler.awaitTermination(10L, TimeUnit.SECONDS);
        this.eventListenerList.clear();
        this.statusMessageListenerList.clear();
    }

    public AggregateStatus getAggregateStatus() {
        return this.as;
    }

    public Future<Void> waitForStatus(Enum state) {
        return this.as.waitForStatus(state);
    }

    public void fireEvent(CCSEvent event) {
        this.eventListenerList.fireEvent((Object)event);
    }

    public void fireEvent(StatusMessage event) {
        this.statusMessageListenerList.fireEvent((Object)event);
    }

    public void schduleAtFixedRate(int i, TimeUnit timeUnit, Runnable runnable) {
        this.scheduler.scheduleAtFixedRate(new RunnableWrapper(runnable), i, i, timeUnit);
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    private static class RunnableWrapper
    implements Runnable {
        private final Runnable runnable;

        public RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error running scheduled runnable", t);
            }
        }
    }
}

