package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;

/**
 * SAL uses astroPy units. CCS is rather more lax about what units are alllowed.
 * This class attempts to make from CCS units to SAL units.
 *
 * @author tonyj
 */
public class UnitConverter {

    private final Properties unitsMap;
    
    UnitConverter() {
       try (InputStream in = UnitConverter.class.getResourceAsStream("units.map");
               InputStreamReader reader = new InputStreamReader(in, Charset.forName("UTF-8"))) {
           unitsMap = new Properties();
           unitsMap.load(reader);
       } catch (IOException x) {
           throw new RuntimeException("Error reading units.map");
       }
    }
    
    public String convertCCSUnitToSALUnit(String ccs) {
        
        if (ccs == null || ccs.isEmpty()) {
            return "unitless";
        }
        String sal = unitsMap.getProperty(ccs.toLowerCase());
        return sal == null ? ccs : sal;
    }
}
