/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAxis;

public class FixedAxis
implements IAxis {
    private int bins;
    private double min;
    private double binWidth;
    private int xunder;
    private int xover;
    private double max;

    public FixedAxis(int bins, double min, double max) {
        if (bins < 1) {
            throw new IllegalArgumentException("bins=" + bins);
        }
        if (max <= min) {
            throw new IllegalArgumentException("max <= min");
        }
        this.bins = bins;
        this.min = min;
        this.binWidth = (max - min) / (double)bins;
        this.max = max;
        this.xunder = 0;
        this.xover = bins + 1;
    }

    public boolean equals(Object o) {
        if (o instanceof FixedAxis) {
            FixedAxis other = (FixedAxis)o;
            return this.bins == other.bins && this.min == other.min && this.binWidth == other.binWidth;
        }
        return false;
    }

    public double binCenter(int index) {
        if (index == -1) {
            return Double.POSITIVE_INFINITY;
        }
        if (index == -2) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.min + this.binWidth * (double)index + this.binWidth / 2.0;
    }

    public int bins() {
        return this.bins;
    }

    public double binLowerEdge(int index) {
        if (index == -2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (index == -1) {
            return this.upperEdge();
        }
        if (Double.isInfinite(this.min)) {
            return this.min;
        }
        return this.min + this.binWidth * (double)index;
    }

    public double binUpperEdge(int index) {
        if (index == -2) {
            return this.min;
        }
        if (index == -1) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isInfinite(this.min)) {
            return this.min;
        }
        return this.min + this.binWidth * (double)(index + 1);
    }

    public double binWidth(int index) {
        if (index == -2) {
            return Double.POSITIVE_INFINITY;
        }
        if (index == -1) {
            return Double.POSITIVE_INFINITY;
        }
        return this.binWidth;
    }

    public int coordToIndex(double coord) {
        if (coord < this.min) {
            return -2;
        }
        int index = (int)Math.floor((coord - this.min) / this.binWidth);
        if (index >= this.bins) {
            return -1;
        }
        return index;
    }

    public double lowerEdge() {
        return this.min;
    }

    public double upperEdge() {
        if (Double.isInfinite(this.max)) {
            return this.max;
        }
        return this.min + this.binWidth * (double)this.bins;
    }

    int xgetBin(double coord) {
        if (coord < this.min) {
            return this.xunder;
        }
        int index = (int)Math.floor((coord - this.min) / this.binWidth);
        if (index > this.bins) {
            return this.xover;
        }
        return index + 1;
    }

    int xmap(int index) {
        if (index >= this.bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return this.xunder;
        }
        if (index == -1) {
            return this.xover;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    public boolean isFixedBinning() {
        return true;
    }
}

