/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;
import org.lsst.ccs.bootstrap.ResourcesTreeProperties;

class ResourcesUtils {
    private static final Properties defaultProperties = new Properties();

    ResourcesUtils() {
    }

    static void setDefaultProperty(String property, String value) {
        defaultProperties.setProperty(property, value);
    }

    static Properties getMergedPropertyFile(ResourcesTree tree, String fileName) {
        return ResourcesUtils.getMergedPropertyFile(tree, fileName, false);
    }

    static Properties getMergedPropertyFile(ResourcesTree tree, String fileName, boolean useSystem) {
        return ResourcesUtils.getMergedProperties(tree, new String[]{fileName}, useSystem, null, new String[]{"properties"});
    }

    static Properties getApplicationDefinitionFile(ResourcesTree tree, String fileName) {
        return ResourcesUtils.getMergedProperties(tree, new String[]{fileName}, false, null, new String[]{"app"});
    }

    static Properties getMergedProperties(ResourcesTree tree, String[] properties, boolean useSystem, ResourcesTreeProperties parentProps, String[] extensions) {
        ResourcesTreeProperties props = parentProps;
        if (useSystem) {
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Adding System Properties to the properties chain");
            }
            props = new ResourcesTreeProperties("SystemProperties", null, props);
            props.putAll((Map<?, ?>)System.getProperties());
        }
        if (properties.length != extensions.length) {
            throw new IllegalArgumentException("Inconsistent array sizes");
        }
        try (InputStream defaultsIn = Bootstrap.getLoaderClass().getResourceAsStream("/ccsDefaults.properties");){
            if (defaultsIn != null) {
                if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                    System.out.println("*** Adding Properties " + BootstrapUtils.getDistributionResourcesDirectory() + "ccsDefaults.properties to properties chain");
                }
                ResourcesTreeProperties parent = props;
                props = new ResourcesTreeProperties("ccsDefaults", BootstrapUtils.getDistributionResourcesDirectory(), parent);
                props.load(defaultsIn);
                String applicationName = Bootstrap.getBootstrapApplication();
                if (applicationName != null && !applicationName.isEmpty()) {
                    props.put("org.lsst.ccs.application.name", applicationName);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Properties dProperties = System.getProperties();
        for (String key : dProperties.stringPropertyNames()) {
            if (!key.startsWith("bootstrap.default.")) continue;
            defaultProperties.put(key.replace("bootstrap.default.", ""), dProperties.getProperty(key));
        }
        if (!defaultProperties.isEmpty()) {
            props = new ResourcesTreeProperties("defaults", null, props);
            props.putAll((Map<?, ?>)defaultProperties);
        }
        List<ResourceDirectory> resourceList = tree.getResourceDirectoryList();
        ListIterator<ResourceDirectory> reverseIterator = resourceList.listIterator(resourceList.size());
        while (reverseIterator.hasPrevious()) {
            ResourceDirectory dir = reverseIterator.previous();
            for (int i = 0; i < properties.length; ++i) {
                Object propertyFileName = properties[i];
                if (propertyFileName == null) continue;
                if (!((String)propertyFileName).endsWith(extensions[i])) {
                    propertyFileName = (String)propertyFileName + "." + extensions[i];
                }
                if (!dir.supportsExtension(extensions[i])) continue;
                Path propertyFilePath = ResourcesUtils.getNormalizedPathIfExistsInResourceDirectories(dir.getResouceDirectoryPath(), (String)propertyFileName, tree.getResourceDirectoryList());
                if (propertyFilePath == null && ((String)propertyFileName).contains(BootstrapUtils.FILE_SEPARATOR)) {
                    propertyFileName = ((String)propertyFileName).substring(((String)propertyFileName).lastIndexOf(BootstrapUtils.FILE_SEPARATOR) + 1);
                    propertyFilePath = ResourcesUtils.getNormalizedPathIfExistsInResourceDirectories(dir.getResouceDirectoryPath(), (String)propertyFileName, tree.getResourceDirectoryList());
                }
                if (propertyFilePath == null || !Files.exists(propertyFilePath, new LinkOption[0])) continue;
                try (InputStream in = Files.newInputStream(propertyFilePath, new OpenOption[0]);){
                    ResourcesTreeProperties parent = props;
                    props = new ResourcesTreeProperties((String)propertyFileName, dir.getResouceDirectoryPath().toString(), parent);
                    props.load(in);
                    if (!Bootstrap.verbose() || Bootstrap.isQuiet()) continue;
                    System.out.println("*** Adding Properties " + dir.getResouceDirectoryPath() + (String)propertyFileName + " to properties chain");
                    continue;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
        return props;
    }

    static void printProperties(Properties props) {
        ResourcesUtils.printProperties(props, null, null);
    }

    static void printProperties(Properties props, StringBuilder sb, Logger logger) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        if (logger != null) {
            logger.log(Level.FINE, "{0}", ResourcesUtils.internalPrintProperties(props, sb));
        } else {
            System.err.println(ResourcesUtils.internalPrintProperties(props, sb));
        }
    }

    private static String internalPrintProperties(Properties props, StringBuilder sb) {
        Object p;
        sb.append("*****************\n");
        if (props instanceof ResourcesTreeProperties) {
            p = (ResourcesTreeProperties)props;
            String output = "Properties from " + ((ResourcesTreeProperties)p).getPropertyFileName();
            if (((ResourcesTreeProperties)p).getResourceDirectory() != null) {
                output = output + " in resource directory " + ((ResourcesTreeProperties)p).getResourceDirectory();
            }
            sb.append(output).append("\n");
        } else {
            sb.append("External System properties");
        }
        p = props.keySet().iterator();
        while (p.hasNext()) {
            Object key = p.next();
            sb.append("\t").append(key).append(" = ").append(props.getProperty((String)key)).append("\n");
        }
        if (props instanceof ResourcesTreeProperties && ((ResourcesTreeProperties)(p = (ResourcesTreeProperties)props)).hasParent()) {
            ResourcesUtils.internalPrintProperties(((ResourcesTreeProperties)p).getParent(), sb);
        }
        return sb.toString();
    }

    static void loadKeySetForProperties(Properties props, Set<Object> set) {
        Set<Object> propsKey = props.keySet();
        for (Object obj : propsKey) {
            if (set.contains(obj)) continue;
            set.add(obj);
        }
        if (props instanceof ResourcesTreeProperties && ((ResourcesTreeProperties)props).getParent() != null) {
            ResourcesUtils.loadKeySetForProperties(((ResourcesTreeProperties)props).getParent(), set);
        }
    }

    static Path getNormalizedPathIfExistsInResourceDirectories(Path directoryPath, String pathToFind, List<ResourceDirectory> dirs) {
        Path p = directoryPath.resolve(pathToFind).normalize();
        for (ResourceDirectory resDir : dirs) {
            if (!p.startsWith(resDir.getResouceDirectoryPath()) || !Files.exists(p, new LinkOption[0])) continue;
            return p;
        }
        return null;
    }

    static InputStream getResourceFromResourceTree(ResourcesTree tree, String resourceName, Logger logger) throws Exception {
        List<ResourceDirectory> resourceList = tree.getResourceDirectoryList();
        for (ResourceDirectory dir : resourceList) {
            Path p;
            if (!dir.supportsExtension(BootstrapResourceUtils.getResourceExtension(resourceName)) || (p = ResourcesUtils.getNormalizedPathIfExistsInResourceDirectories(dir.getResouceDirectoryPath(), resourceName, tree.getResourceDirectoryList())) == null) continue;
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Found resource " + dir.getResouceDirectoryPath() + resourceName);
            }
            if (logger != null) {
                logger.log(Level.FINE, "Found resource {0}", p);
            }
            return Files.newInputStream(p, new OpenOption[0]);
        }
        return null;
    }
}

