/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RequestResult {
    private final Serializable payload;
    private double size = Double.NaN;
    private final long start;
    private long delta;
    private final int numberOfRecords;
    private volatile int numberOfRecordsPublished = 0;

    RequestResult(Serializable payload, int numberOfRecords) {
        this.payload = payload;
        this.start = System.currentTimeMillis();
        this.numberOfRecords = numberOfRecords;
    }

    RequestResult(Serializable payload, int numberOfRecords, double size) {
        this(payload, numberOfRecords);
        this.size = size;
    }

    public double getRequestSize() {
        if (Double.isNaN(this.size)) {
            this.size = RequestResult.sizeOf(this.payload);
        }
        return this.size;
    }

    public void addPublishedRecord() {
        ++this.numberOfRecordsPublished;
    }

    public void done() {
        this.delta = System.currentTimeMillis() - this.start;
    }

    public long getTimeInMillis() {
        return this.delta;
    }

    public int getNumberOfRecordsPublished() {
        return this.numberOfRecordsPublished;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    private static double sizeOf(Object object) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);){
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException ieo) {
            ieo.printStackTrace();
            return 0.0;
        }
        return (double)byteOutputStream.toByteArray().length / 1000.0;
    }
}

