/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.dataselection;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.DataType;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.DataTypeDialog;
import org.lsst.ccs.gconsole.plugins.trending.dataselection.PresetList;

public class PresetsDialog {
    private final JScrollPane root;
    private final JButton deleteButton;
    private final JButton newButton;
    private final JButton okButton;
    private final JTable table;
    private final PresetList presetList;
    private DataType selectedPreset;

    private PresetsDialog(PresetList data) {
        this.presetList = data;
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(e -> {
            DataType ts = this.getSelectedPreset();
            if (ts != null) {
                this.presetList.delete(ts);
            }
        });
        this.newButton = new JButton("New...");
        this.newButton.addActionListener(e -> {
            DataType ts = DataTypeDialog.defineDataType(this.newButton, null);
            if (ts != null) {
                ts = this.presetList.insert(ts);
                this.setSelectedPreset(ts);
            }
        });
        this.okButton = new JButton(" OK ");
        this.okButton.addActionListener(e -> {
            this.selectedPreset = this.getSelectedPreset();
            Window w = SwingUtilities.getWindowAncestor(this.okButton);
            if (w != null) {
                w.setVisible(false);
            }
        });
        this.table = new JTable(this.presetList);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            DataType ts = this.getSelectedPreset();
            this.deleteButton.setEnabled(ts != null);
        });
        if (this.presetList.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.table.setMinimumSize(this.table.getPreferredSize());
        this.deleteButton.setEnabled(this.getSelectedPreset() != null);
        this.root = new JScrollPane(this.table);
    }

    public static DataType managePresets(Component parent, PresetList data) {
        PresetsDialog dialog = new PresetsDialog(data);
        JOptionPane.showOptionDialog(parent, dialog.root, "Trending Data Type Presets", -1, -1, null, new JButton[]{dialog.deleteButton, dialog.newButton, dialog.okButton}, dialog.okButton);
        return dialog.selectedPreset;
    }

    private DataType getSelectedPreset() {
        int index = this.table.getSelectedRow();
        return index == -1 ? null : this.presetList.get(index);
    }

    private void setSelectedPreset(DataType ts) {
        int index = this.presetList.indexOf(ts);
        if (index == -1) {
            this.table.getSelectionModel().clearSelection();
        } else {
            this.table.getSelectionModel().setSelectionInterval(index, index);
        }
    }
}

