/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.ComponentTree;

public class CommandListPanel
extends JList<DictionaryCommand>
implements TreeSelectionListener {
    private final AgentPanel aPanel;
    private final ComponentTree componentTree;
    private final CommandComparator comparator = new CommandComparator();
    private Dictionary currentDictionary;
    private DictionaryCommand currentCommand;

    public CommandListPanel(AgentPanel agentPanel) {
        this.aPanel = agentPanel;
        this.componentTree = agentPanel.componentTree;
        this.getSelectionModel().setSelectionMode(0);
        this.setCellRenderer(new CommandListRenderer());
    }

    public boolean isVisibleCommandSelected() {
        DictionaryCommand dc = (DictionaryCommand)this.getSelectedValue();
        return dc == null ? false : !this.aPanel.isCommandLocked(dc);
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        this.update();
    }

    public void update() {
        if (this.currentDictionary != null) {
            this.currentCommand = (DictionaryCommand)this.getSelectedValue();
        }
        this.currentDictionary = (Dictionary)this.componentTree.getSelectedUserObject();
        DefaultListModel model = new DefaultListModel();
        if (this.currentDictionary != null) {
            ArrayList<DictionaryCommand> commandList = new ArrayList<DictionaryCommand>(this.currentDictionary.size());
            for (DictionaryCommand dc2 : this.currentDictionary) {
                if (this.aPanel.descriptor.isHideSystem() && dc2.getCategory().equals((Object)Command.CommandCategory.SYSTEM) || this.aPanel.descriptor.isHideLocked() && this.aPanel.isCommandLocked(dc2)) continue;
                commandList.add(dc2);
            }
            commandList.sort(this.comparator);
            commandList.forEach(dc -> model.addElement(dc));
        }
        this.setModel(model);
        if (this.currentDictionary != null && this.currentCommand != null) {
            this.setSelectedValue(this.currentCommand, true);
        }
    }

    private class CommandComparator
    implements Comparator<DictionaryCommand> {
        private CommandComparator() {
        }

        @Override
        public int compare(DictionaryCommand c1, DictionaryCommand c2) {
            boolean v2;
            boolean v1 = CommandListPanel.this.aPanel.isCommandLocked(c1);
            if (v1 == (v2 = CommandListPanel.this.aPanel.isCommandLocked(c2))) {
                int out = c1.getCommandName().compareTo(c2.getCommandName());
                return out == 0 ? c1.getArguments().length - c2.getArguments().length : out;
            }
            return v1 ? 1 : -1;
        }
    }

    private class CommandListRenderer
    extends DefaultListCellRenderer {
        private CommandListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jlist, Object e, int i, boolean isSelected, boolean cellHasFocus) {
            int fontStyle;
            super.getListCellRendererComponent(jlist, e, i, isSelected, cellHasFocus);
            DictionaryCommand dc = (DictionaryCommand)e;
            this.setText(dc.getCommandName());
            if (CommandListPanel.this.aPanel.isCommandLocked(dc)) {
                this.setForeground(Color.GRAY);
                fontStyle = 2;
            } else {
                fontStyle = 0;
            }
            if (dc.getCategory() == Command.CommandCategory.USER) {
                fontStyle |= 1;
            }
            this.setFont(this.getFont().deriveFont(fontStyle));
            return this;
        }
    }
}

