/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider.param.quant;

import nom.tam.fits.compression.algorithm.quant.QuantizeOption;
import nom.tam.fits.compression.provider.param.api.ICompressColumnParameter;
import nom.tam.fits.compression.provider.param.api.ICompressHeaderParameter;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.fits.compression.provider.param.base.CompressParameters;
import nom.tam.fits.compression.provider.param.quant.ZBlankColumnParameter;
import nom.tam.fits.compression.provider.param.quant.ZBlankParameter;
import nom.tam.fits.compression.provider.param.quant.ZQuantizeParameter;
import nom.tam.fits.compression.provider.param.quant.ZScaleColumnParameter;
import nom.tam.fits.compression.provider.param.quant.ZZeroColumnParameter;

public abstract class QuantizeParameters
extends CompressParameters {
    private final ZQuantizeParameter quantz;
    private final ZBlankParameter blank;
    private final ZBlankColumnParameter blankColumn;
    private final ZZeroColumnParameter zero;
    private final ZScaleColumnParameter scale;

    public QuantizeParameters(QuantizeOption option) {
        this.quantz = new ZQuantizeParameter(option);
        this.blank = new ZBlankParameter(option);
        this.blankColumn = new ZBlankColumnParameter(option);
        this.zero = new ZZeroColumnParameter(option);
        this.scale = new ZScaleColumnParameter(option);
    }

    @Override
    protected ICompressColumnParameter[] columnParameters() {
        return new ICompressColumnParameter[]{this.blankColumn, this.zero, this.scale};
    }

    protected ICompressParameters copyColumnDetails(QuantizeParameters quantizeParameters) {
        quantizeParameters.blankColumn.setOriginal(this.blankColumn);
        quantizeParameters.zero.setOriginal(this.zero);
        quantizeParameters.scale.setOriginal(this.scale);
        return quantizeParameters;
    }

    @Override
    protected ICompressHeaderParameter[] headerParameters() {
        if (this.blank.isActive()) {
            return new ICompressHeaderParameter[]{this.quantz, this.blank};
        }
        return new ICompressHeaderParameter[]{this.quantz};
    }
}

