/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Mapping {
    private final List<PatternPlus> patterns;

    public static Mapping defaultMapping() {
        return Mapping.getMapping("pattern.map");
    }

    public static Mapping getMapping(String mapFileName) {
        Mapping mapping;
        block8: {
            InputStream in = Mapping.class.getResourceAsStream(mapFileName);
            try {
                mapping = new Mapping(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException x) {
                    throw new RuntimeException("Failed to load default pattern.map", x);
                }
            }
            in.close();
        }
        return mapping;
    }

    public Mapping(InputStream in) throws IOException {
        block11: {
            this.patterns = new ArrayList<PatternPlus>();
            Pattern legacyPattern = Pattern.compile("(\\w+)\\s*:\\s(.*)");
            Pattern flexiblePattern = Pattern.compile("(\\w+)\\s*:\\s*\\|\\s*(.+)\\s*\\|\\s*(.+)\\s*\\|\\s*(.+)\\s*\\|");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line;
                block5: while (true) {
                    if ((line = reader.readLine()) == null) {
                        break block11;
                    }
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    boolean flexibleMatching = line.contains("|");
                    Matcher flexibleMatcher = flexiblePattern.matcher(line);
                    Matcher legacyMatcher = legacyPattern.matcher(line);
                    if (flexibleMatching) {
                        String[] items = line.split("\\|");
                        if (items.length < 4) {
                            throw new IllegalArgumentException("Invalid line: " + line);
                        }
                        if (!items[0].contains(":")) {
                            throw new IllegalArgumentException("Invalid key: " + items[0] + "; it should be in the format key: ");
                        }
                        String key = items[0].replace(":", "").trim();
                        String value = items[1].trim();
                        Pattern pattern = Pattern.compile(value);
                        String location = items[2].trim();
                        String pathAfter = items[3].trim();
                        PatternPlus patternPlus = new PatternPlus(pattern, key, location, pathAfter);
                        this.patterns.add(patternPlus);
                        int i = 4;
                        while (true) {
                            if (i >= items.length) continue block5;
                            patternPlus.addTag(new Tag(items[i]));
                            ++i;
                        }
                    }
                    if (!legacyMatcher.matches()) break;
                    String key = legacyMatcher.group(1);
                    String value = legacyMatcher.group(2);
                    Pattern pattern = Pattern.compile(value, 2);
                    this.patterns.add(new PatternPlus(pattern, key));
                }
                throw new IOException("Invalid mapping file line: " + line);
            }
        }
    }

    public List<PatternPlus> getPatternList() {
        return Collections.unmodifiableList(this.patterns);
    }

    public Match match(String path) {
        for (PatternPlus patternPlus : this.patterns) {
            Matcher matcher = patternPlus.getPattern().matcher(path);
            if (!matcher.matches()) continue;
            return new Match(matcher, patternPlus);
        }
        return null;
    }

    public Map<Pattern, String> getPatterns() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class PatternPlus {
        private final Pattern pattern;
        private final String patternName;
        private final String location;
        private final String after;
        private final List<Tag> tags = new ArrayList<Tag>();

        PatternPlus(Pattern pattern, String patternName) {
            this.pattern = pattern;
            this.patternName = patternName;
            this.location = null;
            this.after = null;
        }

        private PatternPlus(Pattern pattern, String patternName, String location, String after) {
            this.pattern = pattern;
            this.patternName = patternName;
            this.location = location;
            this.after = after;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getPatternName() {
            return this.patternName;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAfter() {
            return this.after;
        }

        void addTag(Tag tag) {
            this.tags.add(tag);
        }

        public List<Tag> getTags() {
            return this.tags;
        }
    }

    public static class Tag {
        private final String name;
        private final String value;

        Tag(String definition) {
            String[] items = definition.split(":");
            if (items.length != 2) {
                throw new IllegalArgumentException("Invalid tag defintion " + definition + "; should be in the form name:value");
            }
            this.name = items[0].trim();
            this.value = items[1].trim();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Match {
        private final Matcher matcher;
        private final PatternPlus patternPlus;
        private final Map<String, String> availableTagsMap = new LinkedHashMap<String, String>();

        private Match(Matcher matcher, PatternPlus patternPlus) {
            this.patternPlus = patternPlus;
            this.matcher = matcher;
            for (Tag t : patternPlus.getTags()) {
                this.availableTagsMap.put(t.getName(), matcher.replaceAll(t.getValue()));
            }
        }

        public String getPatternName() {
            return this.patternPlus.getPatternName();
        }

        public String getLocation() {
            if (this.patternPlus.getLocation() == null) {
                StringBuilder builder = new StringBuilder();
                int groupCount = this.matcher.groupCount();
                for (int g = 1; g < groupCount; ++g) {
                    builder.append(this.matcher.group(g));
                }
                return builder.toString();
            }
            return this.matcher.replaceAll(this.patternPlus.getLocation());
        }

        public String getPathAfterMatch() {
            if (this.patternPlus.getAfter() == null) {
                int groupCount = this.matcher.groupCount();
                return this.matcher.group(groupCount);
            }
            return this.matcher.replaceAll(this.patternPlus.getAfter());
        }

        public Set<String> getTagNames() {
            return this.availableTagsMap.keySet();
        }

        public String getTagValue(String tag) {
            if (!this.availableTagsMap.containsKey(tag)) {
                throw new IllegalArgumentException("Tag " + tag + " is not a valid tag: " + this.availableTagsMap.keySet());
            }
            return this.availableTagsMap.get(tag);
        }
    }
}

