/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.examples;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class Main {
    public static void main(String[] args) throws IOException {
        URI uri = URI.create("ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/");
        FileSystem restfs = FileSystems.newFileSystem(uri, Collections.emptyMap());
        System.out.println("I got " + restfs);
        Path pathInRestServer = restfs.getPath("image-handling-dc01.app", new String[0]);
        System.out.println(pathInRestServer.toUri());
        System.out.println("I got " + pathInRestServer);
        System.out.println(Files.exists(pathInRestServer, new LinkOption[0]));
        System.out.println(Files.size(pathInRestServer));
        System.out.println(Files.getLastModifiedTime(pathInRestServer, new LinkOption[0]));
        List<String> readAllLines = Files.readAllLines(pathInRestServer);
        System.out.printf("Read %d lines\n", readAllLines.size());
        Path root = restfs.getRootDirectories().iterator().next();
        System.out.println(Files.isDirectory(root, new LinkOption[0]));
        Stream<Path> stream = Files.list(root);
        stream.forEach(path -> System.out.println(path.getFileName().toString()));
        BasicFileAttributeView fileAttributeView = Files.getFileAttributeView(pathInRestServer, BasicFileAttributeView.class, new LinkOption[0]);
    }
}

