/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Const;

public final class SearchField
extends JTextField {
    private final ArrayList<String> all;
    private ArrayList<String> candidates;
    private String prevText;
    private String selected;
    private int maxItems = 20;
    private JPopupMenu popup;
    private final ActionListener itemsListener;

    public SearchField(List<String> choices) {
        this.all = new ArrayList<String>(choices);
        this.addCaretListener(e -> this.updatePopup());
        this.itemsListener = e -> {
            this.selected = e.getActionCommand();
            this.fireActionPerformed();
        };
        this.updatePopup();
    }

    public void setMaxItemsInPopup(int nItems) {
        this.maxItems = nItems;
    }

    @Override
    protected void fireActionPerformed() {
        if (this.selected == null) {
            String text = this.getText();
            if (text.trim().isEmpty()) {
                this.setActionCommand("");
            } else {
                String out = "";
                for (String s : this.all) {
                    if (!s.contains(text)) continue;
                    out = s;
                    break;
                }
                this.setActionCommand(out);
            }
        } else {
            this.setActionCommand(this.selected);
        }
        super.fireActionPerformed();
    }

    private void updatePopup() {
        this.selected = null;
        String text = this.getText();
        if (text.isEmpty()) {
            this.hidePopup();
            this.candidates = this.all;
        } else {
            if (!text.contains(this.prevText)) {
                this.candidates = this.all;
            }
            ArrayList<String> items = new ArrayList<String>(this.maxItems);
            int n = 0;
            for (String candidate : this.candidates) {
                if (!candidate.contains(text)) continue;
                if (++n > this.maxItems) {
                    this.hidePopup();
                    this.setForeground(Color.BLACK);
                    return;
                }
                items.add(candidate);
            }
            if (items.isEmpty()) {
                this.hidePopup();
                this.setForeground(Color.RED);
            } else {
                this.showPopup(items);
                this.setForeground(Color.BLACK);
            }
            this.candidates = items;
        }
        this.prevText = text;
        this.requestFocusInWindow();
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup = null;
        }
    }

    private void showPopup(List<String> items) {
        this.popup = new JPopupMenu();
        for (String item : items) {
            JMenuItem menuItem = new JMenuItem(item);
            menuItem.addActionListener(this.itemsListener);
            this.popup.add(menuItem);
        }
        this.popup.show(this, 0, this.getHeight());
    }

    public static String search(List<String> choices, String title, Component parent) {
        Dialog dialog = new Dialog(choices, title, parent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.field.requestFocusInWindow();
        dialog.setVisible(true);
        return dialog.select;
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            List<String> items = Arrays.asList("uno", "dos", "tres", "treinta", "sorok/chetyre/s/polovinoy");
            String selected = SearchField.search(items, "Search for a channel", null);
            System.out.println(selected);
        });
    }

    private static final class Dialog
    extends JDialog {
        String select;
        final SearchField field;

        Dialog(List<String> items, String title, Component parent) {
            super(parent == null ? null : SwingUtilities.getWindowAncestor(parent), null, Dialog.ModalityType.APPLICATION_MODAL);
            this.setLayout(new BorderLayout());
            this.setResizable(false);
            Box box = Box.createHorizontalBox();
            this.add((Component)box, "North");
            box.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            box.add(new JLabel(title));
            box.add(Box.createRigidArea(Const.HDIM));
            box.add(Box.createHorizontalGlue());
            JButton cancel = new JButton("Cancel");
            box.add(cancel);
            cancel.addActionListener(e -> {
                this.select = null;
                this.dispose();
            });
            this.field = new SearchField(items);
            this.add((Component)this.field, "South");
            this.field.addActionListener(e -> {
                String item = e.getActionCommand();
                this.select = "".equals(item) ? null : item;
                this.dispose();
            });
        }
    }
}

