/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Segment;

public class GuiderCCD
extends CCD {
    private final GuiderType guiderType;

    GuiderCCD(CCDType ccdType, GuiderType guiderType) {
        super(ccdType);
        this.guiderType = guiderType;
    }

    @Override
    public String getName() {
        return this.guiderType.getName();
    }

    public static GuiderCCD createGuiderCCD(CCDType ccdType, GuiderType guiderType) {
        GuiderCCD ccd = new GuiderCCD(ccdType, guiderType);
        for (int s = 0; s < ccd.getSerialChildrenCount(); ++s) {
            for (int p = 0; p < ccd.getParallelChildrenCount(); ++p) {
                int channel = p == 0 ? 16 - s : 1 + s;
                Segment segment = Segment.createCCDSegment(ccdType, channel);
                ccd.addChildGeometry(segment, p, s);
            }
        }
        return ccd;
    }

    public GuiderType getGuiderType() {
        return this.guiderType;
    }

    public static enum GuiderType {
        GUIDER0("SG0"),
        GUIDER1("SG1");

        private final String name;

        private GuiderType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

