/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.persist;

import java.awt.Component;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Describe;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.ConsoleService;
import org.lsst.ccs.gconsole.services.persist.CreationDialog;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.CreatorExecutable;
import org.lsst.ccs.gconsole.services.persist.CreatorFromDescriptor;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.SaveDescriptorDialog;

@Plugin(name="Persistence Service Plugin", id="persistence-service", description="Service that facilitates persisting data between the graphical console sessions.")
public class PersistenceService
extends ConsolePlugin
implements ConsoleService {
    private final ArrayList<Creator> factories = new ArrayList();

    @Override
    public void startService() {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Enumeration<URL> e = loader.getResources("gui/creators.txt");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                try {
                    InputStream ins = url.openStream();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(ins));){
                        String line;
                        while ((line = in.readLine()) != null) {
                            try {
                                Create an;
                                int mod;
                                Class<?> clazz = Class.forName(line.trim());
                                for (Method method : clazz.getDeclaredMethods()) {
                                    mod = method.getModifiers();
                                    if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || (an = method.getAnnotation(Create.class)) == null) continue;
                                    this.factories.add(new CreatorExecutable(method, null));
                                }
                                for (Executable executable : clazz.getConstructors()) {
                                    mod = ((Constructor)executable).getModifiers();
                                    if (!Modifier.isPublic(mod) || (an = ((Constructor)executable).getAnnotation(Create.class)) == null) continue;
                                    this.factories.add(new CreatorExecutable(executable, null));
                                }
                            }
                            catch (ClassNotFoundException | SecurityException exception) {
                            }
                        }
                    }
                    finally {
                        if (ins == null) continue;
                        ins.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PersistenceService getService() {
        return Console.getConsole().getSingleton(PersistenceService.class);
    }

    public <T extends Persistable> T make(Persistable.Descriptor descriptor) {
        Creator creator;
        boolean hasTargetClass;
        Persistable out = null;
        Class<?> targetClass = null;
        Class<?> descriptorClass = descriptor.getClass();
        Describe an = descriptorClass.getAnnotation(Describe.class);
        if (an != null) {
            try {
                targetClass = Class.forName(an.className());
            }
            catch (ClassNotFoundException | LinkageError throwable) {}
        } else {
            targetClass = descriptorClass.getEnclosingClass();
        }
        boolean bl = hasTargetClass = targetClass != null && Persistable.class.isAssignableFrom(targetClass);
        if (hasTargetClass) {
            try {
                Constructor<?> c = targetClass.getConstructor(descriptorClass);
                out = (Persistable)c.newInstance(descriptor);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException c) {
                // empty catch block
            }
        }
        Creator.Descriptor desc = descriptor.getCreator();
        if (out == null && desc != null && (creator = this.getFactory(desc.getCategory(), desc.getPath())) != null) {
            try {
                out = creator.make(desc.getParameters());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (out == null && hasTargetClass) {
            try {
                Constructor<?> c = targetClass.getConstructor(new Class[0]);
                out = (Persistable)c.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException c) {
                // empty catch block
            }
        }
        if (out != null) {
            Persistable.Descriptor d = out.getDescriptor();
            d.setCategory(descriptor.getCategory());
            d.setPath(descriptor.getPath());
            d.setName(descriptor.getName());
            d.setDescription(descriptor.getDescription());
            d.setCreator(desc);
            out.restore(descriptor);
        }
        return (T)out;
    }

    public <T extends Persistable> T make(String category, String path, Object ... parameters) {
        try {
            Creator creator = this.getFactory(category, path);
            return (T)creator.make(parameters);
        }
        catch (Exception x) {
            return null;
        }
    }

    public <T extends Persistable> T make(String category, String path, String[] parameters) {
        try {
            Creator creator = this.getFactory(category, path);
            return (T)creator.make(parameters);
        }
        catch (Exception x) {
            return null;
        }
    }

    public <T extends Persistable> T make(Creator.Descriptor desc) {
        try {
            Creator creator = this.getFactory(desc.getCategory(), desc.getPath());
            return (T)creator.make(desc.getParameters());
        }
        catch (Exception x) {
            return null;
        }
    }

    public <T extends Persistable> T make(Persistable.Descriptor descriptor, String title, Component parent, String category) {
        if (category == null) {
            if (descriptor != null) {
                category = descriptor.getCategory();
            }
            if (category == null) {
                throw new IllegalArgumentException("Persistable category is not defined");
            }
        }
        ArrayList<Creator> ff = this.getSaved(category);
        ff.addAll(this.getFactories(category));
        return (T)CreationDialog.make(descriptor, title, parent, ff);
    }

    public void save(Persistable.Descriptor descriptor) {
        try {
            String category = descriptor.getCategory();
            String path = descriptor.getPath();
            ArrayList<Persistable.Descriptor> dd = this.getSavedDescriptors(category);
            Iterator<Persistable.Descriptor> it = dd.iterator();
            while (it.hasNext()) {
                Persistable.Descriptor d = it.next();
                if (!path.equals(d.getPath())) continue;
                it.remove();
            }
            dd.add(descriptor);
            Path filePath = this.getConsole().getHomeDirectory().resolve(this.categoryToFileName(category));
            if (Files.notExists(filePath, new LinkOption[0])) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            }
            BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));
            try (XMLEncoder encoder = new XMLEncoder(out);){
                for (Persistable.Descriptor d : dd) {
                    encoder.writeObject(d);
                }
            }
        }
        catch (IOException | NullPointerException x) {
            this.getConsole().error("Unable to save descriptor", x);
        }
    }

    public void saveAs(Persistable.Descriptor descriptor, String title, Component parent) {
        try {
            descriptor = SaveDescriptorDialog.show(descriptor, title, parent);
            this.save(descriptor);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void delete(Persistable.Descriptor descriptor) {
        try {
            String category = descriptor.getCategory();
            if (category == null) {
                category = descriptor.getCreator().getCategory();
            }
            String path = descriptor.getPath();
            ArrayList<Persistable.Descriptor> dd = this.getSavedDescriptors(category);
            Iterator<Persistable.Descriptor> it = dd.iterator();
            while (it.hasNext()) {
                Persistable.Descriptor d = it.next();
                if (!path.equals(d.getPath())) continue;
                it.remove();
            }
            Path filePath = this.getConsole().getHomeDirectory().resolve(this.categoryToFileName(category));
            if (Files.notExists(filePath, new LinkOption[0])) {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            }
            BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));
            try (XMLEncoder encoder = new XMLEncoder(out);){
                for (Persistable.Descriptor d : dd) {
                    encoder.writeObject(d);
                }
            }
        }
        catch (IOException | NullPointerException x) {
            this.getConsole().error("Unable to delete descriptor", x);
        }
    }

    public Persistable.Descriptor load(String category, String title, Component parent) {
        ArrayList<Creator> ff = this.getSaved(category);
        Creator c = CreationDialog.select(title, parent, ff);
        if (c instanceof CreatorFromDescriptor) {
            return ((CreatorFromDescriptor)c).getDescriptor();
        }
        return null;
    }

    public Persistable edit(Persistable before, String title, Component parent) {
        Persistable after = before.edit(title, parent);
        if (after == null) {
            PersistenceService service = Console.getConsole().getSingleton(PersistenceService.class);
            after = service.make(before.save(), title, parent, before.getCategory());
        }
        return after;
    }

    public Creator getFactory(String category, String path) {
        for (Creator f : this.factories) {
            if (!path.equals(f.getPath()) || category != null && !category.equals(f.getCategory())) continue;
            return f;
        }
        return null;
    }

    public List<Creator> getFactories(String category) {
        if (category == null) {
            return new ArrayList<Creator>(this.factories);
        }
        return this.factories.stream().filter(f -> category.equals(f.getCategory())).collect(Collectors.toList());
    }

    public ArrayList<Persistable.Descriptor> getSavedDescriptors(String category) {
        ArrayList<Persistable.Descriptor> out = new ArrayList<Persistable.Descriptor>();
        try {
            Path filePath = this.getConsole().getHomeDirectory().resolve(this.categoryToFileName(category));
            try {
                XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(Files.newInputStream(filePath, new OpenOption[0])), null, e -> {});
                try {
                    try {
                        while (true) {
                            Persistable.Descriptor d = (Persistable.Descriptor)decoder.readObject();
                            out.add(d);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        decoder.close();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        decoder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ArrayIndexOutOfBoundsException | ClassCastException exception) {}
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return out;
    }

    private ArrayList<Creator> getSaved(String category) {
        ArrayList<Persistable.Descriptor> dd = this.getSavedDescriptors(category);
        ArrayList<Creator> out = new ArrayList<Creator>(dd.size());
        for (Persistable.Descriptor d : dd) {
            out.add(new CreatorFromDescriptor(d));
        }
        return out;
    }

    private String categoryToFileName(String category) {
        StringBuilder sb = new StringBuilder("saved/");
        boolean start = true;
        for (char c : category.toLowerCase().toCharArray()) {
            if (start) {
                if (!Character.isLetter(c)) continue;
                sb.append(c);
                start = false;
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '_') continue;
            sb.append(c);
        }
        if (start) {
            throw new IllegalArgumentException("Cannot convert category " + category + " to file name");
        }
        sb.append(".xml");
        return sb.toString();
    }
}

