/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.BasicChannel;
import org.lsst.ccs.gconsole.services.aggregator.ChannelSelector;
import org.lsst.ccs.gconsole.services.aggregator.MutableAgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.StateChannel;
import org.lsst.ccs.gconsole.services.aggregator.StaticChannel;
import org.lsst.ccs.services.AgentLockService;

class AgentHandle {
    private final AgentInfo agentInfo;
    final AgentStatusAggregator aggregator;
    private volatile StateBundle state;
    private volatile ConfigurationInfo configuration;
    private ArrayList<ListenerHandle> listeners;
    LinkedHashMap<String, AgentChannel> channels;
    private final ArrayList<AgentChannel> staticChannels;
    private final HashSet<String> deserializationErrors = new HashSet(2);
    private boolean noWatchedChannels = true;
    final String AGENT_PREFIX;
    final String TIME_PATH;
    final String STATE_PREFIX;
    final String CONFIG_PREFIX;
    final String LOCK_PATH;
    private static final Logger LOG = Logger.getLogger(AgentHandle.class.getName());
    private final AgentLock noLock;

    AgentHandle(AgentInfo agentInfo, AgentStatusAggregator aggregator) {
        this.aggregator = aggregator;
        this.agentInfo = agentInfo;
        String agent = agentInfo.getName();
        this.AGENT_PREFIX = agent + "/";
        this.TIME_PATH = agent + "/runtimeInfo/current time";
        this.STATE_PREFIX = agent + "/states/";
        this.CONFIG_PREFIX = agent + "/configuration/";
        this.LOCK_PATH = this.STATE_PREFIX + "locked by";
        TreeMap<String, Object> agentProperties = new TreeMap<String, Object>();
        agentInfo.getAgentProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> agentProperties.put((String)key, value)));
        this.staticChannels = new ArrayList(agentProperties.size());
        String prefix = agentInfo.getName() + "/static/";
        agentProperties.forEach((key, value) -> this.staticChannels.add(new StaticChannel(agentInfo, prefix + key, value)));
        this.noLock = AgentLockInfo.createRelease((String)agentInfo.getName(), (String)"");
    }

    AgentInfo getAgent() {
        return this.agentInfo;
    }

    synchronized AgentChannel getChannel(String path) {
        return this.channels == null ? null : this.channels.get(path);
    }

    StateBundle getState() {
        return this.state;
    }

    ConfigurationInfo getConfiguration() {
        return this.configuration;
    }

    boolean noDictionary() {
        return this.channels == null;
    }

    synchronized List<AgentChannel> getDictionaryChannels() {
        return this.channels == null ? Collections.emptyList() : new ArrayList<AgentChannel>(this.channels.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMessage(StatusMessage mess) {
        boolean firstState = this.state == null;
        boolean firstConfig = this.configuration == null;
        this.state = mess.getState();
        if (mess instanceof StatusConfigurationInfo) {
            try {
                this.configuration = ((StatusConfigurationInfo)mess).getConfigurationInfo();
            }
            catch (EmbeddedObjectDeserializationException x) {
                this.logDeserializationError(mess, x);
                return;
            }
        }
        if (this.noDictionary()) {
            return;
        }
        if (this.noWatchedChannels) {
            if (mess instanceof StatusSubsystemData && ((StatusSubsystemData)mess).getDataAttributes().get("taskName") == null) {
                AgentHandle x = this;
                synchronized (x) {
                    this.readTrendingData(mess, null);
                }
            }
            return;
        }
        MutableAgentStatusEvent event = new MutableAgentStatusEvent(this.aggregator, mess);
        AgentHandle agentHandle = this;
        synchronized (agentHandle) {
            boolean changed;
            if (mess instanceof StatusStateChangeNotification) {
                if (firstState) {
                    this.readState(this.state, event);
                } else {
                    StateBundle diff = this.state.diffState(((StatusStateChangeNotification)mess).getOldState());
                    this.readState(diff, event);
                }
            } else if (mess instanceof StatusConfigurationInfo) {
                this.readConfiguration(firstConfig ? this.configuration.getAllParameterInfo() : this.configuration.getLatestChanges(), event);
            } else {
                this.readTrendingData(mess, event);
            }
            Instant time = mess.getCCSTimeStamp().getUTCInstant();
            AgentChannel channel = this.channels.get(this.TIME_PATH);
            if (channel != null && (changed = channel.set(time))) {
                event.addChange(channel, "value");
            }
        }
        this.notifyListeners(event);
    }

    void onDisconnect() {
        if (this.channels == null) {
            return;
        }
        AgentChannel phase = this.channels.get(this.STATE_PREFIX + PhaseState.class.getSimpleName());
        if (phase != null) {
            phase.set(PhaseState.OFF_LINE.toString());
        }
        this.agentInfo.getAgentProperties().setProperty("agentOffline", "true");
        ArrayList<AgentChannel> removed = new ArrayList<AgentChannel>(this.channels.values());
        removed.addAll(this.staticChannels);
        AgentStatusEvent event = new AgentStatusEvent(this.aggregator, Collections.singletonList(this.agentInfo), null, Collections.emptyMap(), Collections.emptyList(), removed);
        this.listeners.forEach(lh -> {
            try {
                lh.global.listener.disconnect(event);
            }
            catch (RuntimeException x) {
                Console.getConsole().getLogger().warn((Object)("Error processing status aggregator event by " + lh.global.listener.getClass()), (Throwable)x);
            }
        });
    }

    synchronized void onDictionary(DataProviderDictionary dictionary) {
        if (this.noDictionary()) {
            List dictChannels = dictionary.getDataProviderInfos();
            this.channels = new LinkedHashMap(dictChannels.size() * 2, 0.99f);
            String section = null;
            block14: for (DataProviderInfo dc : dictChannels) {
                HashMap<String, Object> attributes;
                String trendingKey;
                Object path;
                DataProviderInfo.Type type;
                try {
                    type = DataProviderInfo.Type.valueOf((String)dc.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE));
                }
                catch (IllegalArgumentException x) {
                    continue;
                }
                switch (type) {
                    case TRENDING: 
                    case MONITORING: {
                        path = dc.getPath();
                        trendingKey = dc.getKey();
                        if (trendingKey == null || trendingKey.equals(path) || trendingKey.isEmpty()) {
                            trendingKey = null;
                        }
                        path = this.AGENT_PREFIX + (String)path;
                        break;
                    }
                    case CONFIGURATION: {
                        path = dc.getPath();
                        path = this.CONFIG_PREFIX + (String)(((String)path).isEmpty() ? "" : (String)path + "/") + dc.getKey();
                        trendingKey = null;
                        break;
                    }
                    case STATE: {
                        String key = dc.getKey();
                        key = key.substring(key.lastIndexOf(46) + 1);
                        path = dc.getPath();
                        path = this.STATE_PREFIX + (String)(((String)path).isEmpty() ? "" : (String)path + "/") + key;
                        trendingKey = null;
                        break;
                    }
                    default: {
                        continue block14;
                    }
                }
                DataProviderInfo.Attribute[] aa = dc.getAttributes();
                if (aa.length == 0 && trendingKey == null) {
                    attributes = null;
                } else {
                    attributes = new HashMap<String, Object>(aa.length * 2);
                    if (trendingKey != null) {
                        attributes.put("_key_", trendingKey);
                    }
                    for (DataProviderInfo.Attribute a : aa) {
                        String av = dc.getAttributeValue(a);
                        if (a == DataProviderInfo.Attribute.DESCRIPTION && DataProviderInfo.Type.MONITORING.name().equals(dc.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE))) {
                            int ii = av.indexOf("\\");
                            if (ii != -1) {
                                section = av.substring(0, ii);
                                av = av.substring(ii + 1);
                            }
                            if (section != null) {
                                attributes.put(AgentChannel.Key.SECTION, section);
                            }
                        }
                        attributes.put(a.getName(), av);
                    }
                }
                this.channels.put((String)path, switch (type) {
                    case DataProviderInfo.Type.STATE -> new StateChannel((String)path, this.agentInfo, attributes, null);
                    default -> new BasicChannel((String)path, this.agentInfo, attributes, null);
                });
            }
            BasicChannel timeChannel = new BasicChannel(this.TIME_PATH, this.agentInfo, null, null);
            this.channels.put(this.TIME_PATH, timeChannel);
            BasicChannel lockChannel = new BasicChannel(this.LOCK_PATH, this.agentInfo, null, null);
            try {
                AgentLockService serv = (AgentLockService)Console.getConsole().getAgentService(AgentLockService.class);
                if (serv != null) {
                    AgentLock lock = serv.getExistingLockForAgent(this.agentInfo.getName());
                    if (lock == null) {
                        lock = this.noLock;
                    }
                    lockChannel.set(lock);
                }
                this.channels.put(this.LOCK_PATH, lockChannel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.channels = new LinkedHashMap<String, AgentChannel>(this.channels);
            this.listeners = new ArrayList();
            for (AgentStatusAggregator.GlobalListenerHandle global : this.aggregator.listeners) {
                MutableAgentStatusEvent event = new MutableAgentStatusEvent(this.aggregator);
                this.addListener(global, event);
                if (event.isEmpty()) continue;
                event.validate();
                try {
                    global.listener.configure(event);
                }
                catch (RuntimeException x) {
                    Console.getConsole().getLogger().warn((Object)("Error processing status aggregator event by " + global.listener.getClass()), (Throwable)x);
                }
            }
            this.listeners.trimToSize();
        }
    }

    void onLockEvent(AgentLock lock) {
        AgentChannel channel;
        if (this.channels != null && (channel = this.channels.get(this.LOCK_PATH)) != null) {
            channel.set(lock == null ? this.noLock : lock);
            MutableAgentStatusEvent event = new MutableAgentStatusEvent(this.aggregator, null);
            event.addChange(channel, "value");
            this.notifyListeners(event);
        }
    }

    void onLoginEvent(String user) {
        AgentChannel channel;
        if (this.channels != null && (channel = this.channels.get(this.LOCK_PATH)) != null) {
            MutableAgentStatusEvent event = new MutableAgentStatusEvent(this.aggregator, null);
            event.addChange(channel, "value");
            this.notifyListeners(event);
        }
    }

    private void notifyListeners(AgentStatusEvent event) {
        if (!event.isEmpty()) {
            this.listeners.forEach(lh -> {
                AgentStatusEvent e = lh.filter(event);
                if (!e.isEmpty()) {
                    try {
                        lh.global.listener.statusChanged(e);
                    }
                    catch (RuntimeException x) {
                        Console.getConsole().getLogger().warn((Object)("Error processing status aggregator event by " + lh.global.listener.getClass()), (Throwable)x);
                    }
                }
            });
        }
    }

    void addListener(AgentStatusAggregator.GlobalListenerHandle global, MutableAgentStatusEvent event) {
        Set<String> paths;
        ArrayList<ChannelSelector> selectors;
        boolean watchAgent;
        if (this.noDictionary()) {
            return;
        }
        String agentName = this.agentInfo.getName();
        boolean bl = watchAgent = global.agents == null || global.agents.contains(agentName);
        if (global.channelSelectors == null) {
            selectors = null;
        } else {
            selectors = new ArrayList<ChannelSelector>(global.channelSelectors.size());
            for (ChannelSelector channelSelector : global.channelSelectors) {
                String agent = channelSelector.getAgent();
                if (!agentName.equals(agent) && (!watchAgent || agent != null)) continue;
                selectors.add(channelSelector);
            }
        }
        if (watchAgent || selectors != null && !selectors.isEmpty()) {
            try {
                global.listener.connect(new AgentStatusEvent(this.aggregator, Collections.singletonList(this.agentInfo), null, null, null, null));
            }
            catch (RuntimeException x) {
                Console.getConsole().getLogger().warn((Object)("Error processing status aggregator event by " + global.listener.getClass()), (Throwable)x);
            }
        } else {
            return;
        }
        if (selectors == null) {
            paths = null;
            event.addAddedChannels(this.channels.values());
            event.addAddedChannels(this.staticChannels);
        } else if (selectors.isEmpty()) {
            paths = Collections.emptySet();
        } else {
            paths = new HashSet();
            block5: for (AgentChannel ch : this.channels.values()) {
                for (ChannelSelector s : selectors) {
                    if (!s.match(ch)) continue;
                    paths.add(ch.getPath());
                    event.addAddedChannel(ch);
                    continue block5;
                }
            }
            block7: for (AgentChannel ch : this.staticChannels) {
                for (ChannelSelector s : selectors) {
                    if (!s.match(ch)) continue;
                    event.addAddedChannel(ch);
                    continue block7;
                }
            }
        }
        if (this.noWatchedChannels && (paths == null || !paths.isEmpty())) {
            this.noWatchedChannels = false;
            if (this.state != null) {
                this.readState(this.state, null);
            }
            if (this.configuration != null) {
                try {
                    this.readConfiguration(this.configuration.getAllParameterInfo(), null);
                }
                catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                    Console.getConsole().getLogger().warn((Object)("Failed to read configuration for " + this.agentInfo.getName()), (Throwable)embeddedObjectDeserializationException);
                }
            }
        }
        ListenerHandle listenerHandle = new ListenerHandle(global, paths);
        this.listeners.add(listenerHandle);
    }

    void removeListener(AgentStatusAggregator.GlobalListenerHandle global) {
        Iterator<ListenerHandle> it = this.listeners.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            ListenerHandle local = it.next();
            if (local.global != global) continue;
            it.remove();
            changed = true;
        }
        if (changed && !this.noWatchedChannels) {
            this.noWatchedChannels = true;
            for (ListenerHandle lh : this.listeners) {
                if (!lh.hasChannels()) continue;
                this.noWatchedChannels = false;
                break;
            }
        }
        if (this.noWatchedChannels) {
            for (AgentChannel c : this.channels.values()) {
                c.set(null);
                c.set(AgentChannel.Key.STATE, null);
            }
        }
    }

    void readState(StateBundle bundle, MutableAgentStatusEvent changeEvent) {
        if (bundle == null) {
            return;
        }
        Map out = bundle.getAllStatesAsStrings();
        for (String string : bundle.getComponentsWithStates()) {
            AgentHandle.addAllStates(bundle.getComponentStateBundle(string), string + "/", out);
        }
        for (Map.Entry entry : out.entrySet()) {
            AgentChannel channel = this.channels.get(this.STATE_PREFIX + (String)entry.getKey());
            if (channel == null || !channel.set(entry.getValue()) || changeEvent == null) continue;
            changeEvent.addChange(channel, "value");
        }
    }

    private static void addAllStates(StateBundle bundle, String prefix, Map<String, String> out) {
        bundle.getInternalStates().forEach((key, value) -> {
            key = key.substring(key.lastIndexOf(46) + 1);
            out.put(prefix + key, (String)value);
        });
        bundle.getDecodedStates().forEach((key, value) -> {
            if (value != null && !(value instanceof DataProviderState)) {
                key = key.substring(key.lastIndexOf(46) + 1);
                out.put(prefix + key, value.toString());
            }
        });
        bundle.getComponentsWithStates().forEach(component -> AgentHandle.addAllStates(bundle.getComponentStateBundle(component), prefix + component + "/", out));
    }

    void readConfiguration(List<ConfigurationParameterInfo> config, MutableAgentStatusEvent changeEvent) {
        if (config == null) {
            return;
        }
        for (ConfigurationParameterInfo conf : config) {
            String p;
            AgentChannel channel = this.getChannelForPublishedData(conf.getComponentName(), this.AGENT_PREFIX);
            if (channel != null) {
                String attributeName = conf.getParameterName();
                channel.set(attributeName, conf);
                if (changeEvent != null) {
                    changeEvent.addChange(channel, attributeName);
                }
            }
            if ((channel = this.getChannelForPublishedData((p = conf.getPathName()).startsWith("/") ? p.substring(1) : p, this.CONFIG_PREFIX)) == null) continue;
            channel.set(conf);
            if (changeEvent == null) continue;
            changeEvent.addChange(channel, "value");
        }
    }

    void readTrendingData(StatusMessage mess, MutableAgentStatusEvent event) {
        try {
            Object o = mess.getEncodedData();
            if (o instanceof KeyValueDataList) {
                KeyValueDataList encodedData = (KeyValueDataList)o;
                for (KeyValueData d : encodedData) {
                    boolean changed;
                    AgentChannel channel;
                    KeyValueData.KeyValueDataType type = d.getType();
                    String attrKey = null;
                    String key = d.getKey();
                    Serializable value = d.getValue();
                    switch (type) {
                        case KeyValueTrendingData: {
                            attrKey = "value";
                            break;
                        }
                        case KeyValueMetaData: {
                            int lastIndex = key.lastIndexOf(47);
                            if (lastIndex > -1) {
                                attrKey = key.substring(lastIndex + 1);
                                key = key.substring(0, lastIndex);
                            }
                            if (!AgentChannel.Key.STATE.equals(attrKey) || value == null) break;
                            try {
                                value = DataProviderState.valueOf((String)value.toString());
                                break;
                            }
                            catch (IllegalArgumentException x) {
                                attrKey = null;
                            }
                        }
                    }
                    if (attrKey == null || (channel = this.getChannelForPublishedData(key, this.AGENT_PREFIX)) == null || !(changed = channel.set(attrKey, value)) || event == null) continue;
                    event.addChange(channel, attrKey);
                }
            }
        }
        catch (EmbeddedObjectDeserializationException x) {
            this.logDeserializationError(mess, x);
        }
    }

    private void logDeserializationError(StatusMessage mess, EmbeddedObjectDeserializationException x) {
        String messageClass = mess.getClass().getName();
        String key = messageClass + "/";
        try {
            ClassNotFoundException xx = (ClassNotFoundException)x.getCause();
            key = key + xx.getMessage();
        }
        catch (ClassCastException xxx) {
            key = key + x.getCause().getClass().getSimpleName();
        }
        if (this.deserializationErrors.add(key)) {
            LOG.log(Level.WARNING, x, () -> "Failed to deserialize ConfigurationInfo from " + this.agentInfo.getName());
        }
    }

    private AgentChannel getChannelForPublishedData(String publishedPath, String prefix) {
        String fullInternalPath = prefix + publishedPath;
        AgentChannel channel = this.channels.get(fullInternalPath);
        return channel;
    }

    private class ListenerHandle {
        final AgentStatusAggregator.GlobalListenerHandle global;
        private final Set<String> paths;

        ListenerHandle(AgentStatusAggregator.GlobalListenerHandle global, Set<String> paths) {
            this.global = global;
            this.paths = paths == null ? null : (paths.isEmpty() ? Collections.emptySet() : new HashSet<String>(paths));
        }

        boolean hasChannels() {
            return this.paths == null || !this.paths.isEmpty();
        }

        AgentStatusEvent filter(AgentStatusEvent event) {
            if (this.paths == null) {
                return event;
            }
            List<AgentChannel> added = event.getAddedChannels();
            added = added.isEmpty() ? Collections.emptyList() : added.stream().filter((? super T c) -> this.paths.contains(c.getPath())).collect(Collectors.toList());
            List<AgentChannel> removed = event.getRemovedChannels();
            removed = removed.isEmpty() ? Collections.emptyList() : removed.stream().filter((? super T c) -> this.paths.contains(c.getPath())).collect(Collectors.toList());
            Map<AgentChannel, List<String>> changes = event.getStatusChanges();
            changes = changes.isEmpty() ? Collections.emptyMap() : changes.entrySet().stream().filter((? super T e) -> this.paths.contains(((AgentChannel)e.getKey()).getPath())).collect(Collectors.toMap(e -> (AgentChannel)e.getKey(), e -> (List)e.getValue()));
            return new AgentStatusEvent(event.getSource(), event.getAgents(), event.getMessage(), changes, added, removed);
        }
    }
}

