/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.nonstop;

import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import org.hibernate.cache.ehcache.EhCacheMessageLogger;
import org.jboss.logging.Logger;

public final class HibernateNonstopCacheExceptionHandler {
    public static final String HIBERNATE_THROW_EXCEPTION_ON_TIMEOUT_PROPERTY = "ehcache.hibernate.propagateNonStopCacheException";
    public static final String HIBERNATE_LOG_EXCEPTION_STACK_TRACE_PROPERTY = "ehcache.hibernate.logNonStopCacheExceptionStackTrace";
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)HibernateNonstopCacheExceptionHandler.class.getName());
    private static final HibernateNonstopCacheExceptionHandler INSTANCE = new HibernateNonstopCacheExceptionHandler();

    private HibernateNonstopCacheExceptionHandler() {
    }

    public static HibernateNonstopCacheExceptionHandler getInstance() {
        return INSTANCE;
    }

    public void handleNonstopCacheException(NonStopCacheException nonStopCacheException) {
        if (Boolean.getBoolean(HIBERNATE_THROW_EXCEPTION_ON_TIMEOUT_PROPERTY)) {
            throw nonStopCacheException;
        }
        if (Boolean.getBoolean(HIBERNATE_LOG_EXCEPTION_STACK_TRACE_PROPERTY)) {
            LOG.debug("Ignoring NonstopCacheException - " + nonStopCacheException.getMessage(), (Throwable)nonStopCacheException);
        } else {
            LOG.debug("Ignoring NonstopCacheException - " + nonStopCacheException.getMessage());
        }
    }
}

