/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Playlist;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.utilities.location.LocationSet;

public class Emulator {
    private static final Logger LOG = Logger.getLogger(Emulator.class.getName());
    private final long emuClient;
    private final Store store;

    Emulator(Store store) throws DAQException {
        this.store = store;
        this.emuClient = this.attachEmuClient(store.getPartition());
    }

    public Playlist openPlaylist(File file) throws DAQException, IOException {
        long playlist = this.openPlaylist(this.emuClient, file.getCanonicalPath());
        return new Playlist(this.store, this, playlist);
    }

    void closePlayList(long playlist) throws DAQException {
        this.closePlaylist(this.emuClient, playlist);
    }

    void addImageToPlaylist(long playlist, Image image) throws DAQException {
        this.addImageToPlaylist(this.emuClient, this.store.getStore(), playlist, image.getMetaData().getId());
    }

    void list(long playlist, List<ImageMetaData> result) throws DAQException {
        this.list(this.emuClient, this.store.getStore(), playlist, result);
    }

    int playlistSize(long playlist) throws DAQException {
        return this.playlistSize(this.emuClient, playlist);
    }

    void startPlaylist(long playlist, boolean repeat) throws DAQException {
        this.startPlaylist(this.emuClient, playlist, repeat);
    }

    public LocationSet getLocations() {
        BitSet locations = this.getLocations(this.emuClient);
        return new LocationSet(locations);
    }

    public void halt() throws DAQException {
        this.halt(this.emuClient);
    }

    public void stop() throws DAQException {
        this.stop(this.emuClient);
    }

    public void restart() throws DAQException {
        this.restart(this.emuClient);
    }

    void detach() throws DAQException {
        this.detachEmuClient(this.emuClient);
    }

    private synchronized native long attachEmuClient(String var1) throws DAQException;

    private synchronized native void detachEmuClient(long var1) throws DAQException;

    private synchronized native long openPlaylist(long var1, String var3) throws DAQException;

    private synchronized native void closePlaylist(long var1, long var3) throws DAQException;

    private synchronized native int playlistSize(long var1, long var3) throws DAQException;

    private synchronized native void list(long var1, long var3, long var5, List<ImageMetaData> var7) throws DAQException;

    private synchronized native void addImageToPlaylist(long var1, long var3, long var5, long var7) throws DAQException;

    private synchronized native void startPlaylist(long var1, long var3, boolean var5) throws DAQException;

    private synchronized native BitSet getLocations(long var1);

    private synchronized native void halt(long var1);

    private synchronized native void stop(long var1);

    private synchronized native void restart(long var1);

    static native String decodeException(int var0);

    static {
        System.loadLibrary("ccs_daq_ims");
    }
}

