/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

public class BackupUtils {
    private static final Pattern PARTITION_PATTERN = Pattern.compile("p(\\d\\d)_(\\d\\d\\d\\d)");
    private static final String FUTURE_PARTITION = "futurePartition";
    private static final int PARTITIONS_TO_KEEP = 16;
    private static final int FUTURE_PARTITIONS = 12;

    public static void main(String[] args) throws SQLException, ParseException {
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)"statusPersister");
        Options commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("p", "partition_table", false, "Partition the table");
        commandLineOptions.addOption("c", "create_missing_partitions", false, "Create missing partitions");
        commandLineOptions.addOption("r", "remove_old_partitions", false, "Remove old partitions");
        commandLineOptions.addOption("pk", "partitions_to_keep", true, "Number of partitions to keep");
        commandLineOptions.getOption("partitions_to_keep").setArgName("PARTITIONS_TO_KEEP");
        commandLineOptions.addOption("fp", "future_partitions", true, "Number of partitions to create in the future");
        commandLineOptions.getOption("future_partitions").setArgName("FUTURE_PARTITIONS");
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(commandLineOptions, args, false);
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(100, "SubsystemBoot", "", commandLineOptions, "", true);
            return;
        }
        Calendar cal = Calendar.getInstance();
        String[] connSplit = p.getProperty("hibernate.connection.url", "").split("/");
        String schemaName = connSplit[connSplit.length - 1];
        try (Connection connection = DriverManager.getConnection(p.getProperty("hibernate.connection.url") + "?user=" + p.getProperty("hibernate.connection.username") + "&password=" + p.getProperty("hibernate.connection.password"));){
            boolean weeklyPartitions;
            int partitionsToKeep = 16;
            if (line.hasOption("partitions_to_keep")) {
                partitionsToKeep = Integer.parseInt(line.getOptionValue("partitionsToKeep"));
            }
            int futurePartitions = 12;
            if (line.hasOption("future_partitions")) {
                futurePartitions = Integer.parseInt(line.getOptionValue("future_partitions"));
            }
            System.out.println("*** Inspecting table ccs_rawData for schema " + schemaName);
            boolean abort = false;
            ArrayList<String> availablePartitions = new ArrayList<String>();
            ArrayList<Long> rowsForPartitions = new ArrayList<Long>();
            ArrayList<Integer> yearForPartitions = new ArrayList<Integer>();
            ArrayList<Integer> indexForPartitions = new ArrayList<Integer>();
            ArrayList<String> removePartitions = new ArrayList<String>();
            int maxIndex = -1;
            PreparedStatement getPartitions = connection.prepareStatement("SELECT TABLE_NAME, PARTITION_NAME, TABLE_ROWS FROM INFORMATION_SCHEMA.PARTITIONS where table_name = 'ccs_rawData' and table_schema = ?;");
            getPartitions.setString(1, schemaName);
            try (ResultSet partitions = getPartitions.executeQuery();){
                while (partitions.next()) {
                    String partitionName = partitions.getString("PARTITION_NAME");
                    long entries = partitions.getLong("TABLE_ROWS");
                    if (partitionName != null) {
                        availablePartitions.add(partitionName);
                        rowsForPartitions.add(entries);
                        Matcher m = PARTITION_PATTERN.matcher(partitionName);
                        boolean isFuturePartition = partitionName.equals(FUTURE_PARTITION);
                        if (!m.matches() && !isFuturePartition) {
                            throw new RuntimeException("The current partition names must be chanaged. We suggest you un-partition the table and start from scratch.\n To remove the partitioned table issue the command: ALTER TABLE ccs_rawData REMOVE PARTITIONING;");
                        }
                        int index = isFuturePartition ? -1 : Integer.valueOf(m.group(1));
                        maxIndex = Math.max(index, maxIndex);
                        indexForPartitions.add(index);
                        yearForPartitions.add(isFuturePartition ? 0 : Integer.valueOf(m.group(2)));
                        continue;
                    }
                    System.out.println("The table is not partitioned and contains " + entries + " rows.");
                }
            }
            boolean bl = maxIndex < 0 ? true : (weeklyPartitions = maxIndex > 12);
            if (weeklyPartitions) {
                BackupUtils.getBeginningOfWeek(cal);
                cal.add(3, -1 * partitionsToKeep);
            } else {
                BackupUtils.getBeginningOfMonth(cal);
                cal.add(2, -1 * partitionsToKeep);
            }
            long removeBeforeMillis = cal.getTimeInMillis();
            if (availablePartitions.isEmpty()) {
                System.out.println("Table ccs_rawData is not partitioned. ");
                if (line.hasOption("partition_table")) {
                    System.out.println("Creating partitioning by range now.");
                    PreparedStatement initializePartitions = connection.prepareStatement("ALTER TABLE ccs_rawData partition by range (time) (  partition futurePartition values less than maxvalue)");
                    initializePartitions.executeUpdate();
                } else {
                    System.out.println("To partition the table by range re-run this program with the \"partition_table\" option.");
                }
                System.out.println();
            } else {
                long futurePartitionTime = -1L;
                long futurePartitionRows = -1L;
                for (int i = 0; i < availablePartitions.size(); ++i) {
                    String partitionName = (String)availablePartitions.get(i);
                    cal.clear();
                    if (partitionName.equals(FUTURE_PARTITION)) {
                        futurePartitionRows = (Long)rowsForPartitions.get(i);
                        continue;
                    }
                    int partitionIndex = (Integer)indexForPartitions.get(i);
                    if (weeklyPartitions) {
                        cal.set(3, partitionIndex);
                    } else {
                        cal.set(2, partitionIndex - 1);
                    }
                    cal.set(1, (Integer)yearForPartitions.get(i));
                    Date startPartition = weeklyPartitions ? BackupUtils.getBeginningOfWeek(cal) : BackupUtils.getBeginningOfMonth(cal);
                    cal.add(weeklyPartitions ? 3 : 2, 1);
                    Date endPartition = cal.getTime();
                    futurePartitionTime = Math.max(futurePartitionTime, endPartition.getTime());
                    System.out.println("Partition " + partitionName + " with " + rowsForPartitions.get(i) + " rows \n \tStarting from " + startPartition + "(" + startPartition.getTime() + ") to " + endPartition + "(" + endPartition.getTime() + ")");
                    if (startPartition.getTime() < removeBeforeMillis) {
                        System.out.println("\t--> Can be removed");
                        removePartitions.add(partitionName);
                    }
                    System.out.println();
                }
                cal.clear();
                cal.setTime(new Date(futurePartitionTime));
                Date startPartition = weeklyPartitions ? BackupUtils.getBeginningOfWeek(cal) : BackupUtils.getBeginningOfMonth(cal);
                System.out.println("Future Partition with " + futurePartitionRows + " rows \n \tStarting from " + startPartition + "(" + startPartition.getTime() + ") ");
            }
            Date startOfFirstWeek = null;
            Date startOfLastWeek = null;
            Date startOfFirstMonth = null;
            Date startOfLastMonth = null;
            long minTime = System.currentTimeMillis();
            long maxTime = 1727766000000L;
            cal.setTimeInMillis(minTime);
            Date startDate = cal.getTime();
            int minWeekInYear = cal.get(3);
            int minMonthInYear = cal.get(2);
            int minYear = cal.get(1);
            if (weeklyPartitions) {
                startOfFirstWeek = BackupUtils.getBeginningOfWeek(cal);
                startOfFirstWeek.setTime(startOfFirstWeek.getTime());
            } else {
                startOfFirstMonth = BackupUtils.getBeginningOfMonth(cal);
                startOfFirstMonth.setTime(startOfFirstMonth.getTime());
            }
            cal.setTimeInMillis(maxTime);
            Date endDate = cal.getTime();
            int maxWeekInYear = cal.get(3);
            int maxMonthInYear = cal.get(2);
            int maxYear = cal.get(1);
            System.out.println("Table time period: " + startDate + " " + endDate);
            if (weeklyPartitions) {
                System.out.println("Table weeks span: " + minWeekInYear + "(" + minYear + ") " + maxWeekInYear + "(" + maxYear + ") ");
            } else {
                System.out.println("Table months span: " + minMonthInYear + "(" + minYear + ") " + maxMonthInYear + "(" + maxYear + ") ");
            }
            if (weeklyPartitions) {
                cal.add(3, futurePartitions);
                startOfLastWeek = BackupUtils.getBeginningOfWeek(cal);
                System.out.println("Partitions will be created up to : " + cal.get(3) + "(" + cal.get(1) + ")");
            } else {
                cal.add(2, futurePartitions);
                startOfLastMonth = BackupUtils.getBeginningOfMonth(cal);
                System.out.println("Partitions will be created up to : " + cal.get(2) + "(" + cal.get(1) + ")");
            }
            int lastMonthId = 1000;
            int lastWeekId = 1000;
            int lastYearId = 1000;
            Date partitionStart = weeklyPartitions ? startOfFirstWeek : startOfFirstMonth;
            boolean missingPartitions = false;
            while (partitionStart.getTime() < (weeklyPartitions ? startOfLastWeek.getTime() : startOfLastMonth.getTime())) {
                cal.setTime(partitionStart);
                SimpleDateFormat yearMonthFormat = weeklyPartitions ? new SimpleDateFormat("ww") : new SimpleDateFormat("MM");
                int week_of_year = cal.get(3);
                int month_of_year = cal.get(2);
                int year = cal.get(1);
                if (weeklyPartitions) {
                    if (week_of_year < lastWeekId && year == lastYearId) {
                        // empty if block
                    }
                } else if (month_of_year < lastMonthId && year == lastYearId) {
                    ++year;
                }
                lastWeekId = week_of_year;
                lastMonthId = month_of_year;
                lastYearId = ++year;
                String partitionName = "p" + yearMonthFormat.format(partitionStart) + "_" + year;
                cal.add(weeklyPartitions ? 3 : 2, 1);
                Date partitionEnd = cal.getTime();
                if (!availablePartitions.remove(partitionName)) {
                    if (line.hasOption("create_missing_partitions")) {
                        System.out.println("Creating " + partitionName + " " + partitionStart + " " + partitionEnd);
                        PreparedStatement createPartition = connection.prepareStatement("ALTER TABLE ccs_rawData     REORGANIZE PARTITION futurePartition INTO (    partition " + partitionName + " values less than (" + partitionEnd.getTime() + "),    partition " + FUTURE_PARTITION + " VALUES LESS THAN maxvalue )");
                        createPartition.executeUpdate();
                    } else {
                        missingPartitions = true;
                        System.out.println("Missing " + partitionName + " " + partitionStart + " " + partitionEnd);
                    }
                }
                partitionStart = partitionEnd;
            }
            if (missingPartitions) {
                System.out.println("To create missing partition re-run this program with the \"create_missing_partitions\" option.");
            }
            System.out.println();
            if (!removePartitions.isEmpty()) {
                if (line.hasOption("remove_old_partitions")) {
                    for (String partitionToRemove : removePartitions) {
                        String backupTableName = "ccs_rawData_" + partitionToRemove + "_backup";
                        System.out.println("Moving partition to backup table " + backupTableName);
                    }
                } else {
                    System.out.println("To remove old partition re-run this program with the \"remove_old_partitions\" option.");
                }
            }
        }
    }

    private static Date getBeginningOfWeek(Calendar cal) {
        cal.set(11, 0);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        cal.clear(9);
        cal.set(7, cal.getFirstDayOfWeek());
        return cal.getTime();
    }

    private static Date getBeginningOfMonth(Calendar cal) {
        cal.set(11, 0);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        cal.clear(9);
        cal.set(5, 1);
        return cal.getTime();
    }

    private static void backupPartition(Connection c, String partitionName, String tableName) throws SQLException {
        PreparedStatement backupPartition = c.prepareStatement("CREATE TABLE " + tableName + " (id bigint NOT NULL AUTO_INCREMENT, doubleData DOUBLE,stringData VARCHAR(255),TIME bigint NOT NULL,dataDescId bigint,PRIMARY KEY (id, TIME),INDEX " + partitionName + "_time_i (TIME),INDEX " + partitionName + "_dataDeId_i (dataDescId) )");
        backupPartition.executeUpdate();
    }
}

