/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.MembershipChangePolicy;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.Probe;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.messaging.jgroups.CCSAddress;
import org.lsst.ccs.messaging.jgroups.JGroupsBusMessagingLayer;

public class Tester {
    private static final AtomicInteger ID = new AtomicInteger();
    private static final String CLUSTER_NAME = "TEST";
    private String name;
    private int rank;
    private String xmlConfigurationFile = "udp_ccs.xml";
    private Properties jgroupsProperties;
    private final boolean showGUI;
    private JChannel channel;
    private JFrame frame;
    private int level = Level.INFO.intValue();
    private Random random = new Random();

    public Tester(String name, boolean showGUI) {
        this.name = name == null ? "Node_" + Integer.toString(ID.getAndIncrement()) : name;
        this.showGUI = showGUI;
        String propertiesConfigurationFile = this.xmlConfigurationFile.replace(".xml", ".properties");
        this.jgroupsProperties = BootstrapResourceUtils.getBootstrapProperties((String)propertiesConfigurationFile, this.getClass());
        String sysPref = "system.property.";
        for (String key : this.jgroupsProperties.stringPropertyNames()) {
            String shortKey;
            if (!key.startsWith(sysPref) || System.getProperty(shortKey = key.substring(sysPref.length())) != null) continue;
            System.setProperty(shortKey, this.jgroupsProperties.getProperty(key));
        }
    }

    public Tester() {
        this(null, false);
    }

    public Tester(boolean showGUI) {
        this(null, showGUI);
    }

    private void start() {
        if (this.showGUI) {
            SwingUtilities.invokeLater(this::makeGUI);
        }
    }

    private void stop() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.channel.close();
    }

    private void makeGUI() {
        this.frame = new JFrame(this.name);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Tester.this.stop();
            }
        });
        Box root = Box.createVerticalBox();
        this.frame.add(new JScrollPane(root));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Output level: "));
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        Level[] levels = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINER, Level.FINEST};
        JComboBox<Level> combo = new JComboBox<Level>(levels);
        combo.setSelectedItem(Level.INFO);
        combo.addActionListener(e -> {
            JComboBox c = (JComboBox)e.getSource();
            this.level = ((Level)c.getSelectedItem()).intValue();
        });
        box.add(combo);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        box = Box.createHorizontalBox();
        JButton b = new JButton("Create channel");
        b.addActionListener(e -> {
            ((JButton)e.getSource()).setEnabled(false);
            this.createChannel();
        });
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        b = new JButton("Connect");
        b.addActionListener(e -> {
            if (e.getActionCommand().equals("Connect")) {
                ((JButton)e.getSource()).setText("Disconnect");
                this.connectChannel(null);
            } else {
                ((JButton)e.getSource()).setText("Connect");
                this.disconnectChannel();
            }
        });
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        box = Box.createHorizontalBox();
        b = new JButton("Send");
        b.addActionListener(e -> this.sendMessage());
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        b = new JButton("View");
        b.addActionListener(e -> this.logView());
        box.add(b);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        box = Box.createHorizontalBox();
        box.add(new JLabel("Probe"));
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        JTextField f = new JTextField();
        f.addActionListener(e -> this.probe(e.getActionCommand()));
        box.add(f);
        box.add(Box.createRigidArea(new Dimension(5, 5)));
        box.add(Box.createHorizontalGlue());
        root.add(box);
        root.add(Box.createRigidArea(new Dimension(5, 5)));
        root.add(Box.createVerticalGlue());
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private String setName(String name) {
        if (this.channel != null) {
            return "Too late, the channel has already been created.";
        }
        this.name = name == null ? "Node_" + Integer.toString(ID.getAndIncrement()) : name;
        return "Changed name to " + this.name;
    }

    private String setRank(int rank) {
        if (this.channel != null) {
            return "Too late, the channel has already been created.";
        }
        if (rank > 15) {
            return "Rank should be less than 16";
        }
        this.rank = rank;
        return "Changed rank to " + this.rank;
    }

    private String setConfig(String config) {
        if (this.channel != null) {
            return "Too late, the channel has already been created.";
        }
        if (!config.startsWith("/") && !config.startsWith("c:")) {
            config = System.getProperty("user.home") + "/" + config;
        }
        this.xmlConfigurationFile = config;
        return "Changed config to " + this.xmlConfigurationFile;
    }

    private String loadProperties(String config) throws Exception {
        if (this.channel != null) {
            return "Too late, the channel has already been created.";
        }
        if (!config.startsWith("/") && !config.startsWith("c:")) {
            config = System.getProperty("user.home") + "/" + config;
        }
        if (!config.endsWith(".properties")) {
            config = config + ".properties";
        }
        Properties prop = new Properties();
        prop.load(new FileInputStream(config));
        prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String newKey = (String)key;
            if (!newKey.startsWith("org.lsst.ccs.jgroups.")) {
                newKey = "org.lsst.ccs.jgroups." + newKey;
            }
            this.jgroupsProperties.put(newKey, value);
        }));
        return "Loaded from " + config;
    }

    private String setProperty(String key, String value) {
        if (!key.startsWith("org.lsst.ccs.jgroups.")) {
            key = "org.lsst.ccs.jgroups." + key;
        }
        this.jgroupsProperties.put(key, value);
        return "Set " + key + "=" + value;
    }

    private String setLogLevel(String level, String protocol) {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        if (protocol == null) {
            this.channel.stack().setLevel(level);
            return "Stack level: " + this.channel.stack().getLevel();
        }
        Protocol prot = this.channel.stack().findProtocol(protocol);
        if (prot == null) {
            return "No such protocol: " + protocol;
        }
        prot.setLevel(level);
        return prot.getName() + " level: " + prot.getLevel();
    }

    private String createChannel() {
        if (this.channel != null) {
            return "Too late, the channel has already been created.";
        }
        try {
            XmlConfigurator configurator = JGroupsBusMessagingLayer.createXmlConfiguratorForBus(this.xmlConfigurationFile, this.jgroupsProperties, CLUSTER_NAME);
            this.channel = new JChannel((ProtocolStackConfigurator)configurator);
            if (this.rank >= 0 && !"true".equalsIgnoreCase(this.jgroupsProperties.getProperty("ccs.jg.disable_rank"))) {
                this.channel.addAddressGenerator((AddressGenerator)new CCSAddress.Generator(this.rank));
            }
            this.channel.setName(this.name);
            String text = "Channel configuration:\n" + this.channel.getProperties();
            this.log(text, Level.FINE);
            this.channel.setReceiver((Receiver)new MessageReceiver());
            return "Created channel " + this.name + " with rank " + this.rank;
        }
        catch (Exception x) {
            return "Error creating channel" + x;
        }
    }

    private String connectChannel(String clusterName) {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        if (this.channel.isConnected()) {
            return "Channel is already connected.";
        }
        if (this.channel.isConnecting()) {
            return "Channel is already connecting.";
        }
        if (clusterName == null) {
            clusterName = CLUSTER_NAME;
        }
        try {
            this.channel.connect(clusterName);
            return "Connected to cluster " + clusterName;
        }
        catch (Exception x) {
            return "Error connecting channel. " + x;
        }
    }

    private String disconnectChannel() {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        if (!this.channel.isConnected()) {
            return "Channel is not connected.";
        }
        try {
            String cluster = this.channel.clusterName();
            this.channel.disconnect();
            return "Disconnected " + this.name + " from cluster " + cluster;
        }
        catch (Exception x) {
            return "Error disconnecting channel. " + x;
        }
    }

    private String sendMessage() {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        if (!this.channel.isConnected()) {
            return "Channel is not connected.";
        }
        try {
            this.channel.send(null, (Object)"default payload");
            return "Sent from " + this.name + " to " + this.channel.clusterName();
        }
        catch (Exception x) {
            return "Error sending message. " + x;
        }
    }

    private String invokeOnChannel(String method) {
        if (this.channel == null) {
            return "Channel does not exist.";
        }
        try {
            return JChannel.class.getMethod(method, new Class[0]).invoke((Object)this.channel, new Object[0]).toString();
        }
        catch (NoSuchMethodException x) {
            return "No such method: " + method;
        }
        catch (IllegalAccessException x) {
            return "IllegalAccessException";
        }
        catch (InvocationTargetException x) {
            return "InvocationTargetException: " + x;
        }
    }

    private String testMembership() {
        if (this.channel == null || !this.channel.isConnected()) {
            return "Channel does not exist or is not connected.";
        }
        List adds = this.channel.getView().getMembers();
        int n = adds.size();
        if (n < 3) {
            return "Just " + n + " nodes, wouldn't be much of a test";
        }
        HashSet all = new HashSet(adds);
        if (all.size() != n) {
            return "Equal addresses, list = " + adds.toString() + ", set = " + ((Object)all).toString();
        }
        MembershipChangePolicy mp = ((GMS)this.channel.getProtocolStack().findProtocol(GMS.class)).getMembershipChangePolicy();
        for (int i = 0; i < 100; ++i) {
            ArrayList aa = new ArrayList(all);
            Collections.shuffle(aa);
            int k = this.random.nextInt(n - 1);
            ArrayList a1 = new ArrayList(aa.subList(0, k + 1));
            ArrayList a2 = new ArrayList(aa.subList(k + 1, n));
            ArrayList subviews = new ArrayList(2);
            subviews.add(a1);
            subviews.add(a2);
            HashSet merged = new HashSet(mp.getNewMembership(subviews));
            if (merged.size() == n) continue;
            return "Found problem:\nV1: [" + a1 + "]\nV2: [" + a2 + "]\nMerged: [" + merged + "]";
        }
        return "No problems found";
    }

    private void logView() {
        this.log(this.channel.getViewAsString(), Level.OFF);
    }

    private String view() {
        try {
            return this.channel.getViewAsString();
        }
        catch (Exception x) {
            return "Error: " + x;
        }
    }

    private void probe(String text) {
        Object[] ss = text.split("\\s");
        this.log(Arrays.toString(ss), Level.FINE);
        try {
            Probe.main((String[])ss);
        }
        catch (Exception x) {
            this.log(x, Level.WARNING);
        }
    }

    private void log(Object what, Level level) {
        JGroupsBusMessagingLayer.getLogger().severe(String.valueOf(what));
    }

    private String processCommand(String s) {
        try {
            String[] ss = s.split("\\s+");
            if (ss.length == 0) {
                return null;
            }
            switch (ss[0]) {
                case "setName": {
                    return this.setName(ss[1]);
                }
                case "setRank": {
                    return this.setRank(Integer.parseInt(ss[1]));
                }
                case "setConfig": {
                    return this.setConfig(ss[1]);
                }
                case "loadProp": {
                    return this.loadProperties(ss[1]);
                }
                case "setProp": {
                    return this.setProperty(ss[1], ss[2]);
                }
                case "setLevel": {
                    switch (ss.length) {
                        case 2: {
                            return this.setLogLevel(ss[1], null);
                        }
                        case 3: {
                            return this.setLogLevel(ss[1], ss[2]);
                        }
                    }
                    return "Wrong number of arguments, should be (level, protocol)";
                }
                case "create": {
                    return this.createChannel();
                }
                case "connect": {
                    return this.connectChannel(ss.length == 1 ? null : ss[1]);
                }
                case "disconnect": {
                    return this.disconnectChannel();
                }
                case "view": {
                    return this.view();
                }
                case "send": {
                    return this.sendMessage();
                }
                case "invoke": {
                    return this.invokeOnChannel(ss[1]);
                }
                case "testMember": {
                    return this.testMembership();
                }
            }
            return "   Commands:\nsetName name\nsetRank int\nsetConfig location\nloadProp file\nsetProp key value\nsetLevel level protocol (fatal, error, warn, info, debug, trace (capitalization not relevant))\ncreate\nconnect clusterName\ndisconnect\nview\nsend\ninvoke method\ntestMember";
        }
        catch (Exception x) {
            return "Error: " + x;
        }
    }

    public static void main(String ... args) throws Exception {
        if (args.length == 0) {
            Tester node = new Tester(true);
            node.start();
            node = new Tester(true);
            node.start();
            node = new Tester(true);
            node.start();
        } else {
            Tester.console(args);
        }
        System.exit(0);
    }

    public static void console(String ... args) throws Exception {
        String command;
        JGroupsBusMessagingLayer.getLogger().severe("Starting JGroups tester");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        Tester tester = new Tester();
        while (!"exit".equalsIgnoreCase(command = reader.readLine())) {
            String response = tester.processCommand(command);
            if (response == null) continue;
            JGroupsBusMessagingLayer.getLogger().severe(response);
        }
    }

    private class MessageReceiver
    extends ReceiverAdapter {
        private MessageReceiver() {
        }

        public void unblock() {
            Tester.this.log("unblock()", Level.FINEST);
        }

        public void block() {
            Tester.this.log("block()", Level.FINEST);
        }

        public void suspect(Address mbr) {
            Tester.this.log("suspect() " + mbr, Level.FINEST);
        }

        public void viewAccepted(View view) {
            Tester.this.log("viewAccepted() " + view, Level.FINEST);
        }

        public void receive(Message msg) {
            Tester.this.log("receive() " + msg.getSrc(), Level.FINEST);
        }
    }
}

