/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.Data;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardBuilder;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.LoggerHelper;

public abstract class BasicHDU<DataClass extends Data>
implements FitsElement {
    private static final int MAX_NAXIS_ALLOWED = 999;
    private static final Logger LOG = LoggerHelper.getLogger(BasicHDU.class);
    public static final int BITPIX_BYTE = 8;
    public static final int BITPIX_SHORT = 16;
    public static final int BITPIX_INT = 32;
    public static final int BITPIX_LONG = 64;
    public static final int BITPIX_FLOAT = -32;
    public static final int BITPIX_DOUBLE = -64;
    protected Header myHeader = null;
    protected DataClass myData = null;
    protected boolean isPrimary = false;

    protected BasicHDU(Header myHeader, DataClass myData) {
        this.myHeader = myHeader;
        this.myData = myData;
    }

    public static BasicHDU<?> getDummyHDU() {
        try {
            ImageData img = new ImageData((Object)null);
            return FitsFactory.hduFactory(ImageHDU.manufactureHeader(img), img);
        }
        catch (FitsException e) {
            LOG.log(Level.SEVERE, "Impossible exception in getDummyHDU", e);
            return null;
        }
    }

    public static boolean isHeader(Header header) {
        return false;
    }

    public static boolean isData(Object o) {
        return false;
    }

    protected void saveReplaceCard(String key, boolean isString, String value) {
        HeaderCard card = HeaderCard.saveNewHeaderCard(key, null, isString);
        card.setValue(value);
        this.myHeader.deleteKey(card.getKey());
        this.myHeader.addLine(card);
    }

    public void addValue(IFitsHeader key, boolean val) throws HeaderCardException {
        this.myHeader.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, double val) throws HeaderCardException {
        this.myHeader.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, int val) throws HeaderCardException {
        this.myHeader.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, String val) throws HeaderCardException {
        this.myHeader.addValue(key.key(), val, key.comment());
    }

    public void addValue(String key, boolean val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public void addValue(String key, double val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public void addValue(String key, int val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public void addValue(String key, String val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    boolean canBePrimary() {
        return false;
    }

    public String getAuthor() {
        return this.getTrimmedString(Standard.AUTHOR);
    }

    public int[] getAxes() throws FitsException {
        int nAxis = this.myHeader.getIntValue(Standard.NAXIS, 0);
        if (nAxis < 0) {
            throw new FitsException("Negative NAXIS value " + nAxis);
        }
        if (nAxis > 999) {
            throw new FitsException("NAXIS value " + nAxis + " too large");
        }
        if (nAxis == 0) {
            return null;
        }
        int[] axes = new int[nAxis];
        for (int i = 1; i <= nAxis; ++i) {
            axes[nAxis - i] = this.myHeader.getIntValue(Standard.NAXISn.n(i), 0);
        }
        return axes;
    }

    public int getBitPix() throws FitsException {
        int bitpix = this.myHeader.getIntValue(Standard.BITPIX, -1);
        switch (bitpix) {
            case -64: 
            case -32: 
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            default: {
                throw new FitsException("Unknown BITPIX type " + bitpix);
            }
        }
        return bitpix;
    }

    public long getBlankValue() throws FitsException {
        if (!this.myHeader.containsKey(Standard.BLANK.key())) {
            throw new FitsException("BLANK undefined");
        }
        return this.myHeader.getLongValue(Standard.BLANK);
    }

    public double getBScale() {
        return this.myHeader.getDoubleValue(Standard.BSCALE, 1.0);
    }

    public String getBUnit() {
        return this.getTrimmedString(Standard.BUNIT);
    }

    public double getBZero() {
        return this.myHeader.getDoubleValue(Standard.BZERO, 0.0);
    }

    public Date getCreationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue(Standard.DATE)).toDate();
        }
        catch (FitsException e) {
            LOG.log(Level.SEVERE, "Unable to convert string to FITS date", e);
            return null;
        }
    }

    public DataClass getData() {
        return this.myData;
    }

    @Deprecated
    public double getEpoch() {
        return this.myHeader.getDoubleValue(Standard.EPOCH, -1.0);
    }

    public double getEquinox() {
        return this.myHeader.getDoubleValue(Standard.EQUINOX, -1.0);
    }

    @Override
    public long getFileOffset() {
        return this.myHeader.getFileOffset();
    }

    public int getGroupCount() {
        return this.myHeader.getIntValue(Standard.GCOUNT, 1);
    }

    public Header getHeader() {
        return this.myHeader;
    }

    public HeaderCardBuilder card(IFitsHeader key) {
        return this.myHeader.card(key);
    }

    public String getInstrument() {
        return this.getTrimmedString(Standard.INSTRUME);
    }

    public Object getKernel() {
        try {
            return ((Data)this.myData).getKernel();
        }
        catch (FitsException e) {
            LOG.log(Level.SEVERE, "Unable to get kernel data", e);
            return null;
        }
    }

    public double getMaximumValue() {
        return this.myHeader.getDoubleValue(Standard.DATAMAX);
    }

    public double getMinimumValue() {
        return this.myHeader.getDoubleValue(Standard.DATAMIN);
    }

    public String getObject() {
        return this.getTrimmedString(Standard.OBJECT);
    }

    public Date getObservationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue(Standard.DATE_OBS)).toDate();
        }
        catch (FitsException e) {
            LOG.log(Level.SEVERE, "Unable to convert string to FITS observation date", e);
            return null;
        }
    }

    public String getObserver() {
        return this.getTrimmedString(Standard.OBSERVER);
    }

    public String getOrigin() {
        return this.getTrimmedString(Standard.ORIGIN);
    }

    public int getParameterCount() {
        return this.myHeader.getIntValue(Standard.PCOUNT, 0);
    }

    public String getReference() {
        return this.getTrimmedString(Standard.REFERENC);
    }

    @Override
    public long getSize() {
        int size = 0;
        if (this.myHeader != null) {
            size = (int)((long)size + this.myHeader.getSize());
        }
        if (this.myData != null) {
            size = (int)((long)size + ((Data)this.myData).getSize());
        }
        return size;
    }

    public String getTelescope() {
        return this.getTrimmedString(Standard.TELESCOP);
    }

    public String getTrimmedString(String keyword) {
        String s = this.myHeader.getStringValue(keyword);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String getTrimmedString(IFitsHeader keyword) {
        String s = this.myHeader.getStringValue(keyword);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public abstract void info(PrintStream var1);

    @Override
    public void read(ArrayDataInput stream) throws FitsException, IOException {
        this.myHeader = Header.readHeader(stream);
        this.myData = this.myHeader.makeData();
        ((Data)this.myData).read(stream);
    }

    @Override
    public boolean reset() {
        return this.myHeader.reset();
    }

    @Override
    public void rewrite() throws FitsException, IOException {
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite HDU");
        }
        this.myHeader.rewrite();
        ((Data)this.myData).rewrite();
    }

    @Override
    public boolean rewriteable() {
        return this.myHeader.rewriteable() && ((Data)this.myData).rewriteable();
    }

    void setPrimaryHDU(boolean newPrimary) throws FitsException {
        HeaderCard card;
        if (newPrimary && !this.canBePrimary()) {
            throw new FitsException("Invalid attempt to make HDU of type:" + this.getClass().getName() + " primary.");
        }
        this.isPrimary = newPrimary;
        if (this.isPrimary && !this.myHeader.getBooleanValue(Standard.GROUPS, false)) {
            this.myHeader.deleteKey(Standard.PCOUNT);
            this.myHeader.deleteKey(Standard.GCOUNT);
        }
        if (this.isPrimary && (card = this.myHeader.findCard(Standard.EXTEND)) == null) {
            this.getAxes();
            this.myHeader.nextCard();
            this.myHeader.addValue((IFitsHeader)Standard.EXTEND, true);
        }
        if (!this.isPrimary) {
            this.myHeader.iterator();
            int pcount = this.myHeader.getIntValue(Standard.PCOUNT, 0);
            int gcount = this.myHeader.getIntValue(Standard.GCOUNT, 1);
            int naxis = this.myHeader.getIntValue(Standard.NAXIS, 0);
            this.myHeader.deleteKey(Standard.EXTEND);
            HeaderCard pcard = this.myHeader.findCard(Standard.PCOUNT);
            HeaderCard gcard = this.myHeader.findCard(Standard.GCOUNT);
            this.myHeader.getCard(2 + naxis);
            if (pcard == null) {
                this.myHeader.addValue((IFitsHeader)Standard.PCOUNT, pcount);
            }
            if (gcard == null) {
                this.myHeader.addValue((IFitsHeader)Standard.GCOUNT, gcount);
            }
            this.myHeader.iterator();
        }
    }

    @Override
    public void write(ArrayDataOutput stream) throws FitsException {
        if (this.myHeader != null) {
            this.myHeader.write(stream);
        }
        if (this.myData != null) {
            ((Data)this.myData).write(stream);
        }
        try {
            stream.flush();
        }
        catch (IOException e) {
            throw new FitsException("Error flushing at end of HDU", e);
        }
    }
}

