/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.serialization.StringSerializer;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.kafka.avro.AvroSchemaMapper;
import org.lsst.ccs.camera.kafka.avro.GenericRecordManager;
import org.lsst.ccs.camera.kafka.avro.KafkaBridge;
import org.lsst.ccs.camera.kafka.avro.RequestResult;
import org.lsst.ccs.camera.kafka.avro.Topic;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;

public class KafkaBrokerBridge
implements KafkaBridge,
HasLifecycle {
    @ConfigurationParameter(isFinal=true, description="Location of the file with the connection information to the Kafka Broker", units="unitless")
    private volatile String kafkaBrokerConnectionFile;
    private static final Logger LOG = Logger.getLogger(KafkaBrokerBridge.class.getName());
    private final Properties kafkaProducerProperties = new Properties();
    private final Properties kafkaAdminProperties = new Properties();
    private Producer<String, GenericRecord> producer;
    private Admin admin;

    private String getPropertyAndCheckNotNull(Properties p, String propertyName) {
        String propertyValue = p.getProperty(propertyName);
        if (propertyValue == null) {
            throw new RuntimeException("Property \"" + propertyName + "\" cannot be null. It must be provided in file " + this.kafkaBrokerConnectionFile);
        }
        return propertyValue;
    }

    public void init() {
        if (this.kafkaBrokerConnectionFile == null) {
            throw new RuntimeException("The kafkaBrokerConnectionFile configuration parameter must be specified and it cannot be null.");
        }
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)this.kafkaBrokerConnectionFile);
        String kafkaBootstrapUrl = this.getPropertyAndCheckNotNull(p, "org.lsst.ccs.kafka.bootstrap.url");
        String schemaRegistryUrl = this.getPropertyAndCheckNotNull(p, "org.lsst.ccs.kafka.registry.url");
        String securityProtocol = this.getPropertyAndCheckNotNull(p, "org.lsst.ccs.kafka.security.protocol");
        String username = this.getPropertyAndCheckNotNull(p, "org.lsst.ccs.kafka.username");
        String password = this.getPropertyAndCheckNotNull(p, "org.lsst.ccs.kafka.password");
        this.kafkaAdminProperties.put("bootstrap.servers", kafkaBootstrapUrl);
        this.kafkaAdminProperties.put("security.protocol", securityProtocol);
        this.kafkaAdminProperties.put("sasl.mechanism", "SCRAM-SHA-512");
        this.kafkaAdminProperties.put("sasl.jaas.config", "org.apache.kafka.common.security.scram.ScramLoginModule required username=\"" + username + "\" password=\"" + password + "\";");
        this.kafkaProducerProperties.putAll((Map<?, ?>)this.kafkaAdminProperties);
        this.kafkaProducerProperties.put("key.serializer", StringSerializer.class);
        this.kafkaProducerProperties.put("value.serializer", KafkaAvroSerializer.class);
        this.kafkaProducerProperties.put("schema.registry.url", schemaRegistryUrl);
        this.kafkaProducerProperties.put("acks", "1");
        LOG.log(Level.INFO, "Creating producer");
        this.producer = new KafkaProducer(this.kafkaProducerProperties);
        LOG.log(Level.INFO, "Creating admin");
        this.admin = Admin.create((Properties)this.kafkaAdminProperties);
    }

    public void shutdown() {
        this.producer.close();
        this.admin.close();
    }

    @Override
    public boolean supportsAggregateRecordsPublication() {
        return false;
    }

    @Override
    public List<String> listTopics() {
        ArrayList<String> availableTopics = new ArrayList<String>();
        try {
            availableTopics.addAll((Collection)this.admin.listTopics().names().get());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.log(Level.WARNING, "Problem fetching the list of topics.", e);
        }
        return availableTopics;
    }

    @Override
    public boolean registerKafkaTopic(Topic topic) {
        NewTopic newTopic = new NewTopic(topic.getFullName(), 1, 3);
        CreateTopicsResult result = this.admin.createTopics(Collections.singleton(newTopic));
        KafkaFuture future = (KafkaFuture)result.values().get(topic.getFullName());
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
        return true;
    }

    @Override
    public RequestResult publishRecordsForSchema(Schema schema, List<GenericRecord> listOfRecords) {
        RequestResult result = new RequestResult((Serializable)((Object)listOfRecords), listOfRecords.size(), 0.0);
        for (GenericRecord record : listOfRecords) {
            ProducerRecord producerRecord = new ProducerRecord(record.getSchema().getFullName(), null, (Object)record);
            this.producer.send(producerRecord);
            this.producer.flush();
        }
        result.done();
        return result;
    }

    public static void main(String[] args) {
        KafkaBrokerBridge proxy = new KafkaBrokerBridge();
        proxy.kafkaBrokerConnectionFile = "kafka-broker-summit.properties";
        proxy.init();
        List<String> allTopics = proxy.listTopics();
        System.out.println("GETTING TOPICS: ");
        for (String topicName : allTopics) {
            System.out.println(topicName);
        }
        System.out.println("**************************");
        AvroSchemaMapper mapper = new AvroSchemaMapper(Camera.MAIN_CAMERA);
        mapper.buildSchemasForLocalDictionaries();
        GenericRecordManager recordManager = new GenericRecordManager(mapper);
        for (int i = 0; i < 1; ++i) {
            System.out.println("Looping " + i);
            long timestamp = System.currentTimeMillis();
            recordManager.addKeyValueForPath("quadbox/BFR/Protection_I", 1.5, timestamp);
            recordManager.addKeyValueForPath("quadbox/BFR/Protection_I/state", "NOMINAL", timestamp);
            recordManager.addKeyValueForPath("quadbox/BFR/Clean_5_24V_I", 1.7, timestamp);
            recordManager.addKeyValueForPath("quadbox/BFR/Clean_5_24V_I/state", "NOMINAL", timestamp);
            for (Topic t : recordManager.getTopicsWithData()) {
                for (GenericRecord record : recordManager.getRecordsForTopic(t)) {
                    System.out.println("Publishing record " + record.getSchema().getFullName());
                    proxy.publishRecordsForSchema(record.getSchema(), Collections.singletonList(record));
                }
            }
        }
        proxy.shutdown();
    }
}

