/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;

public class Transmission {
    private final Client sender_;
    private final Client receiver_;
    private final Message msg_;
    private final String msgId_;
    private final String msgTag_;
    private final List listenerList_;
    private final ChangeEvent evt_;
    private Response response_;
    private Throwable error_;
    private boolean senderUnreg_;
    private boolean receiverUnreg_;
    private long doneTime_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Transmission(Client sender, Client receiver, Message msg, String msgTag, String msgId) {
        this.sender_ = sender;
        this.receiver_ = receiver;
        this.msg_ = msg;
        this.msgTag_ = msgTag;
        this.msgId_ = msgId;
        this.listenerList_ = new ArrayList();
        this.evt_ = new ChangeEvent(this);
        this.doneTime_ = Long.MAX_VALUE;
    }

    public Client getSender() {
        return this.sender_;
    }

    public Client getReceiver() {
        return this.receiver_;
    }

    public Message getMessage() {
        return this.msg_;
    }

    public String getMessageTag() {
        return this.msgTag_;
    }

    public String getMessageId() {
        return this.msgId_;
    }

    public void setResponse(Response response) {
        this.response_ = response;
        this.fireChange();
    }

    public Response getResponse() {
        return this.response_;
    }

    public void setError(Throwable error) {
        this.error_ = error;
        logger_.log(Level.WARNING, "Error in hub operation: " + error.getMessage(), error);
        this.fireChange();
    }

    public Throwable getError() {
        return this.error_;
    }

    public void setSenderUnregistered() {
        this.senderUnreg_ = true;
        this.fireChange();
    }

    public void setReceiverUnregistered() {
        this.receiverUnreg_ = true;
        this.fireChange();
    }

    public long getDoneTime() {
        return this.doneTime_;
    }

    public boolean isDone() {
        return this.error_ != null || this.response_ != null || this.msgId_ == null && this.msgTag_ == null || this.receiverUnreg_;
    }

    public Status getStatus() {
        if (this.error_ != null) {
            return Status.EXCEPTION;
        }
        if (this.response_ != null) {
            String status = this.response_.getStatus();
            if ("samp.ok".equals(status)) {
                return Status.OK;
            }
            if ("samp.warning".equals(status)) {
                return Status.WARNING;
            }
            if ("samp.error".equals(status)) {
                return Status.ERROR;
            }
            if (status == null) {
                return Status.NONE;
            }
            return new Status("Completed (" + status + ")", Status.WARNING_COLOR, true);
        }
        if (this.msgId_ == null && this.msgTag_ == null) {
            return Status.NOTIFIED;
        }
        if (this.receiverUnreg_) {
            return Status.ORPHANED;
        }
        if (!$assertionsDisabled && this.isDone()) {
            throw new AssertionError();
        }
        return Status.PENDING;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList_.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList_.remove(listener);
    }

    private void fireChange() {
        if (this.doneTime_ == Long.MAX_VALUE && this.isDone()) {
            this.doneTime_ = System.currentTimeMillis();
        }
        Iterator it = this.listenerList_.iterator();
        while (it.hasNext()) {
            ChangeListener listener = (ChangeListener)it.next();
            listener.stateChanged(this.evt_);
        }
    }

    static {
        $assertionsDisabled = !Transmission.class.desiredAssertionStatus();
        logger_ = Logger.getLogger(Transmission.class.getName());
    }

    public static class Status {
        private final String text_;
        private final Color iconColor_;
        private final boolean isDone_;
        private static final Color PENDING_COLOR = Color.BLACK;
        private static final Color OK_COLOR = new Color(49152);
        private static final Color ERROR_COLOR = new Color(0xC00000);
        private static final Color WARNING_COLOR = new Color(8413232);
        private static final Color NOTIFY_COLOR = new Color(0x808080);
        private static final Status OK = new Status("Success", OK_COLOR, true);
        private static final Status WARNING = new Status("Warning", WARNING_COLOR, true);
        private static final Status ERROR = new Status("Error", ERROR_COLOR, true);
        private static final Status NONE = new Status("Completed (??)", WARNING_COLOR, true);
        private static final Status NOTIFIED = new Status("Notified", NOTIFY_COLOR, true);
        private static final Status EXCEPTION = new Status("Exception", ERROR_COLOR, true);
        private static final Status ORPHANED = new Status("Orphaned", WARNING_COLOR, true);
        private static final Status PENDING = new Status("...pending...", PENDING_COLOR, false);

        Status(String text, Color iconColor, boolean isDone) {
            this.text_ = text;
            this.iconColor_ = iconColor;
            this.isDone_ = isDone;
        }

        public String getText() {
            return this.text_;
        }

        public Icon getIcon(final int height) {
            final int width = (int)Math.floor(0.866 * (double)height);
            return new Icon(){

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    int[] xs = new int[]{x, x + width, x};
                    int[] ys = new int[]{y, y + height / 2, y + height};
                    Color gcolor = g.getColor();
                    g.setColor(Status.this.iconColor_);
                    if (Status.this.isDone_) {
                        g.drawPolygon(xs, ys, 3);
                    } else {
                        g.fillPolygon(xs, ys, 3);
                    }
                    g.setColor(gcolor);
                }

                public int getIconWidth() {
                    return width;
                }

                public int getIconHeight() {
                    return height;
                }
            };
        }

        public String toString() {
            return this.text_;
        }
    }
}

