/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.readout;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.readout.ReadOutParameters;
import org.lsst.ccs.utilities.readout.ReadOutRegisterMap;

public class ReadOutParametersNew
extends ReadOutParameters {
    private static final Logger LOG = Logger.getLogger(ReadOutParametersNew.class.getName());
    private static final String UNDER_COLS = "UnderCols";
    private static final String PRE_COLS = "PreCols";
    private static final String READ_COLS = "ReadCols";
    private static final String POST_COLS = "PostCols";
    private static final String READ_COLS2 = "ReadCols2";
    private static final String OVER_COLS = "OverCols";
    private static final String PRE_ROWS = "PreRows";
    private static final String READ_ROWS = "ReadRows";
    private static final String POST_ROWS = "PostRows";
    private static final String OVER_ROWS = "OverRows";
    private static final String OP_FLAGS = "OpFlags";
    public static final String[] DEFAULT_NAMES = new String[]{"UnderCols", "PreCols", "ReadCols", "PostCols", "ReadCols2", "OverCols", "PreRows", "ReadRows", "PostRows", "OverRows", "OpFlags"};

    ReadOutParametersNew(int[] registers, ReadOutRegisterMap registerMap) {
        super(ReadOutParametersNew.computeCCDType(registers, registerMap), registers, registerMap);
    }

    @Override
    public int getSerialReadPixels() {
        return this.getValue(UNDER_COLS) + this.getValue(READ_COLS) + this.getValue(READ_COLS2) + this.getValue(OVER_COLS);
    }

    @Override
    public int getParallelReadPixels() {
        return this.getValue(READ_ROWS) + this.getValue(OVER_ROWS);
    }

    @Override
    void validate() {
        boolean isValid = true;
        CCDType ccdType = this.getCCDType();
        int totalParallelPixels = ccdType.getCCDGeometryConstants().getSegmentParallelActiveSize();
        if (this.getValue(PRE_ROWS) + this.getValue(READ_ROWS) + this.getValue(OVER_ROWS) != totalParallelPixels) {
            LOG.log(Level.WARNING, "Parallel parameters are invalid: {0}", this);
            isValid = false;
        }
        int totalSerialPixels = ccdType.getCCDGeometryConstants().getSegmentSerialActiveSize() + ccdType.getCCDGeometryConstants().getSegmentSerialPrescanSize();
        if (this.getValue(UNDER_COLS) + this.getValue(PRE_COLS) + this.getValue(READ_COLS) + this.getValue(READ_COLS2) != totalSerialPixels) {
            LOG.log(Level.WARNING, "Serial parameters are invalid: {0}", this);
            isValid = false;
        }
        if (!isValid) {
            LOG.warning("The geometry values in the Fits Headers will be incorrect.");
        }
    }

    private static CCDType computeCCDType(int[] registers, ReadOutRegisterMap registerMap) {
        int opFlags = registers[registerMap.getIndex(OP_FLAGS)];
        if ((opFlags & 1) != 0) {
            return new ITLCCDType();
        }
        if ((opFlags & 2) != 0) {
            return new E2VCCDType();
        }
        throw new RuntimeException(String.format("CCDType cannot be obtained from opFlags: %x", opFlags));
    }

    @Override
    public int getTotalParallelSize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getSerialPrescan() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getTotalSerialSize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

