/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.kafka;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.lsst.sal.kafka.SALKafkaHashTable;
import org.lsst.sal.kafka.SALKafkaObject;

public class SALKafkaSALFileReader {
    private final List<SALKafkaObject> commands = new ArrayList<SALKafkaObject>();
    private final List<SALKafkaObject> events = new ArrayList<SALKafkaObject>();
    private final List<SALKafkaObject> telemetry = new ArrayList<SALKafkaObject>();
    private final Map<String, SALKafkaObject> simpleSALClassNameToObjectMap = new HashMap<String, SALKafkaObject>();
    private final Map<String, SALKafkaObject> schemaToObjectMap = new HashMap<String, SALKafkaObject>();
    private final File avroTemplatesDir;
    private String cscName;
    private SALKafkaHashTable hashTable;
    private SALKafkaObject ackObject;

    SALKafkaSALFileReader(File avroTemplatesDir, Class c, String resource) {
        this.avroTemplatesDir = avroTemplatesDir;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(c.getResourceAsStream(resource)));){
            this.init(reader);
            String ackTokens = "ack org.lsst.sal.kafka.SALKafkaAck " + this.cscName + ".ackcmd int ack int error java.lang.String result java.lang.String identity int origin int cmdtype double timeout";
            this.ackObject = this.createSALObject(ackTokens.split(" "));
            Collections.sort(this.commands, (o1, o2) -> o1.getSalClass().compareTo(o2.getSalClass()));
            for (int index = 0; index < this.commands.size(); ++index) {
                this.commands.get(index).setIndex(index + 1);
            }
        }
        catch (IOException | NullPointerException x) {
            throw new RuntimeException("Error reading resource: " + resource, x);
        }
    }

    private void init(BufferedReader salFile) throws IOException, SecurityException, IllegalArgumentException {
        boolean firstLine = true;
        int n = 1;
        while (true) {
            String line = salFile.readLine();
            try {
                if (line == null) break;
                if (!(line = line.trim()).startsWith("#") && line.length() != 0) {
                    if (firstLine) {
                        this.cscName = line.substring(line.lastIndexOf(95) + 1);
                        this.hashTable = SALKafkaHashTable.read(this.avroTemplatesDir, this.cscName);
                        firstLine = false;
                    } else {
                        String[] split = line.split("\\s+");
                        if (split.length < 3 || (split.length - 3) % 2 != 0) {
                            throw new IOException("Bad line: " + line);
                        }
                        this.createSALObject(split);
                    }
                }
            }
            catch (IOException x) {
                throw new IOException(String.format("Error reading line %d: %s", n, line), x);
            }
            ++n;
        }
    }

    private SALKafkaObject createSALObject(String[] tokenizedLine) throws IOException {
        try {
            SALKafkaObject salObject = new SALKafkaObject(tokenizedLine, this.hashTable, this.avroTemplatesDir, this.cscName);
            switch (salObject.getType()) {
                case COMMAND: {
                    this.commands.add(salObject);
                    break;
                }
                case EVENT: 
                case STATE: {
                    this.events.add(salObject);
                    break;
                }
                case TELEMETRY: {
                    this.telemetry.add(salObject);
                    break;
                }
                case ACK: {
                    break;
                }
                default: {
                    throw new IOException("Unsupported type " + (Object)((Object)salObject.getType()));
                }
            }
            this.simpleSALClassNameToObjectMap.put(salObject.getSimpleSALClass(), salObject);
            this.schemaToObjectMap.put(salObject.getSchema().getFullName(), salObject);
            return salObject;
        }
        catch (ReflectiveOperationException ex) {
            throw new IOException("Error parsing SALFile", ex);
        }
    }

    List<SALKafkaObject> getCommands() {
        return this.commands;
    }

    List<SALKafkaObject> getEvents() {
        return this.events;
    }

    List<SALKafkaObject> getTelemetry() {
        return this.telemetry;
    }

    String getCscName() {
        return this.cscName;
    }

    SALKafkaObject getSALObject(Class aClass) {
        return this.simpleSALClassNameToObjectMap.get(aClass.getCanonicalName());
    }

    SALKafkaObject getAckObject() {
        return this.ackObject;
    }

    SALKafkaObject findObjectForSchema(Schema schema) {
        return this.schemaToObjectMap.get(schema.getFullName());
    }
}

