/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.Condition;
import DDS.ConditionSeqHolder;
import DDS.DomainParticipantFactory;
import DDS.Duration_t;
import DDS.WaitSetInterface;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opensplice.dds.dcps.ConditionImpl;
import org.opensplice.dds.dcps.GuardConditionImpl;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.Utilities;
import org.opensplice.dds.dcps.WaitSetBase;

public class WaitSetImpl
extends WaitSetBase
implements WaitSetInterface {
    private static final long serialVersionUID = -6919928181265050955L;
    private final Set<Condition> conditions = Collections.synchronizedSet(new HashSet());
    private final Set<GuardConditionImpl> guards = Collections.synchronizedSet(new HashSet());

    protected int denit() {
        return super.deinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaitSetImpl() {
        long uWaitset = 0L;
        WaitSetImpl waitSetImpl = this;
        synchronized (waitSetImpl) {
            uWaitset = WaitSetImpl.jniWaitSetNew();
        }
        this.set_user_object(uWaitset);
    }

    private void finalizeArray(ConditionSeqHolder activeCond, int nrTriggeredConditions) {
        assert (activeCond.value != null);
        if (nrTriggeredConditions != activeCond.value.length) {
            Condition[] matchingArr = Arrays.copyOf(activeCond.value, nrTriggeredConditions);
            activeCond.value = matchingArr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int collectDetachedConditions(ConditionSeqHolder activeCond) {
        int nr = 0;
        Set<Condition> set = this.conditions;
        synchronized (set) {
            assert (activeCond.value != null);
            if (activeCond.value.length < this.conditions.size()) {
                activeCond.value = new Condition[this.conditions.size()];
            }
            for (ConditionImpl conditionImpl : this.conditions) {
                if (conditionImpl.is_alive() != 9) continue;
                activeCond.value[nr++] = conditionImpl;
            }
        }
        return nr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int _wait(ConditionSeqHolder active_conditions, Duration_t timeout) {
        int result = 0;
        int nrTriggeredConditions = 0;
        int maxConditions = 0;
        ReportStack.start();
        if (active_conditions == null) {
            result = 3;
            ReportStack.report(result, "active_conditions 'null' is invalid");
        } else {
            result = Utilities.checkDuration(timeout);
            while (result == 0 && nrTriggeredConditions == 0) {
                Object[] attachedGuards;
                Set<GuardConditionImpl> set = this.guards;
                synchronized (set) {
                    Set<Condition> set2 = this.conditions;
                    synchronized (set2) {
                        maxConditions = this.conditions.size() + this.guards.size() + 1;
                    }
                    attachedGuards = this.guards.toArray();
                    if (active_conditions.value == null) {
                        active_conditions.value = new Condition[maxConditions];
                    }
                }
                long uObject = this.get_user_object();
                if (uObject != 0L) {
                    long resultCombo = this.jniWait(uObject, active_conditions, attachedGuards, maxConditions, timeout.sec, timeout.nanosec);
                    result = (int)(resultCombo & 0xFFFFFFFFFFFFFFFFL);
                    if (result == -1) {
                        nrTriggeredConditions = this.collectDetachedConditions(active_conditions);
                        result = 0;
                    } else {
                        nrTriggeredConditions = (int)(resultCombo >> 32);
                    }
                    this.finalizeArray(active_conditions, nrTriggeredConditions);
                    continue;
                }
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0 && result != 10);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int attachGeneralCondition(Condition condition, long uCondition) {
        int result;
        Set<Condition> set = this.conditions;
        synchronized (set) {
            assert (!this.conditions.contains(condition));
            result = this.jniAttachCondition(this.get_user_object(), uCondition, uCondition);
            if (result == 0) {
                boolean insertOK = this.conditions.add(condition);
                assert (insertOK);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int attachGuardCondition(GuardConditionImpl guardCond) {
        int result;
        Set<GuardConditionImpl> set = this.guards;
        synchronized (set) {
            assert (!this.guards.contains(guardCond));
            result = this.trigger();
            if (result == 0) {
                boolean insertOK = this.guards.add(guardCond);
                assert (insertOK);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int detachGeneralCondition(Condition condition, long uCondition) {
        int result;
        Set<Condition> set = this.conditions;
        synchronized (set) {
            assert (this.conditions.contains(condition));
            result = this.jniDetachCondition(this.get_user_object(), uCondition);
            if (result == 0 || result == 9) {
                boolean removeOK = this.conditions.remove(condition);
                assert (removeOK);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int detachGuardCondition(GuardConditionImpl guardCond) {
        Set<GuardConditionImpl> set = this.guards;
        synchronized (set) {
            assert (this.guards.contains(guardCond));
            int result = this.trigger();
            if (result == 0) {
                boolean removeOK = this.guards.remove(guardCond);
                assert (removeOK);
            }
            return result;
        }
    }

    @Override
    public int attach_condition(Condition cond) {
        int result = 0;
        ReportStack.start();
        if (cond instanceof GuardConditionImpl) {
            GuardConditionImpl guard = (GuardConditionImpl)cond;
            result = guard.attach_waitset(this);
        } else if (cond instanceof ConditionImpl) {
            ConditionImpl ci = (ConditionImpl)cond;
            result = ci.attach_waitset(this);
        } else {
            result = 3;
            ReportStack.report(result, "cond is invalid.");
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int detach_condition(Condition cond) {
        int result = 0;
        ReportStack.start();
        if (cond instanceof GuardConditionImpl) {
            GuardConditionImpl guard = (GuardConditionImpl)cond;
            result = guard.detach_waitset(this);
        } else if (cond instanceof ConditionImpl) {
            ConditionImpl ci = (ConditionImpl)cond;
            result = ci.detach_waitset(this);
        } else {
            result = 3;
            ReportStack.report(result, "cond is invalid.");
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get_conditions(ConditionSeqHolder seq) {
        int result = 0;
        ReportStack.start();
        if (seq != null) {
            HashSet<Condition> allConditions = new HashSet<Condition>();
            Set<Condition> set = this.conditions;
            synchronized (set) {
                Set<GuardConditionImpl> set2 = this.guards;
                synchronized (set2) {
                    allConditions.addAll(this.conditions);
                    allConditions.addAll(this.guards);
                    int nrOfCond = allConditions.size();
                    if (seq.value == null || seq.value.length != nrOfCond) {
                        seq.value = new Condition[nrOfCond];
                    }
                    Iterator i = allConditions.iterator();
                    int n = 0;
                    while (i.hasNext()) {
                        seq.value[n++] = (Condition)i.next();
                    }
                    return 0;
                }
            }
        }
        result = 3;
        ReportStack.report(result, "attached_conditions 'null' is invalid.");
        ReportStack.flush(this, result != 0);
        return result;
    }

    protected int trigger() {
        long uWaitset = 0L;
        int result = 0;
        uWaitset = this.get_user_object();
        if (uWaitset != 0L) {
            result = this.jniTrigger(uWaitset, 0L);
        }
        return result;
    }

    @Override
    protected void finalize() throws Throwable {
        long uWaitset = this.get_user_object();
        if (uWaitset != 0L) {
            this.jniWaitSetFree(uWaitset);
        }
        super.finalize();
    }

    @Override
    protected int getDomainId() {
        int domainId = -1;
        long uWaitset = this.get_user_object();
        if (uWaitset != 0L) {
            domainId = this.jniWaitSetGetDomainId(uWaitset);
        }
        return domainId;
    }

    private native int jniTrigger(long var1, long var3);

    private static native long jniWaitSetNew();

    private native void jniWaitSetFree(long var1);

    private native long jniWait(long var1, ConditionSeqHolder var3, Object[] var4, int var5, int var6, int var7);

    private native int jniAttachCondition(long var1, long var3, long var5);

    private native int jniDetachCondition(long var1, long var3);

    private native int jniWaitSetGetDomainId(long var1);

    static {
        DomainParticipantFactory.get_instance();
    }
}

