/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.refrig;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelSingle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.ImageView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

public class VacuumPage {
    private final String VHX_UTT_GCC_01 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_GCC_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VHX_UTT_GHF_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_GHF_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_GCC_02 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VHX_UUT_VGC_01 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_VGC_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String L3_O_RING = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String L3_HOUSING_0_RING = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String FEEDTHRU_RING_O_RING = "demo-subsystem-with-monitoring/main";
    private final String PUMP_PLATE_0_RING = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String[] VHX_UTT_PIP_04 = new String[]{"demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1"};
    private final String[] VCR_UTT_PIP_00_thru_05 = new String[]{"demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1"};
    private final String[] VHX_UTT_PIP_03 = new String[]{"demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1"};
    private final String[] VCR_UTT_PIP_04 = new String[]{"demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1"};
    private final String VHX_UTT_PTM_01 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_PTM_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private ImageView view;
    private final MonitorField gaugeField;
    private final MonitorField maField;
    private final MonitorField lsField;
    private final MonitorField rpmField;
    private final MonitorField valveField;

    public VacuumPage() {
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = 0;
        fv.format = "<html><center>%1$6.1e<br>Torr";
        this.gaugeField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "%1$5.3f ma";
        this.maField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "%1$5.1f l/s";
        this.lsField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "%1$6.0f rpm";
        this.rpmField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "open";
        this.valveField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
    }

    public ImageView getView() {
        if (this.view != null) {
            return this.view;
        }
        try {
            BufferedImage back = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/util/refrig/vacuum.png"));
            this.view = new ImageView("Vacuum", back, 0.5, 2.0);
            this.placeGauge(0.4231, 0.082, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1");
            this.placeGauge(0.3739, 0.273, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1");
            this.placeGauge(0.5572, 0.257, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1");
            this.placeGauge(0.5203, 0.4696, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1");
            this.placeGauge(0.551, 0.8048, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1");
            this.placeValve(0.5055, 0.3338, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", 0.5f, 1.0f);
            this.placeValve(0.3469, 0.4936, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", 0.5f, 1.0f);
            this.placeValve(0.0701, 0.8628, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", 1.0f, 0.5f);
            this.placeValve(0.1562, 0.8586, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", 1.0f, 0.5f);
            this.placeValve(0.2312, 0.8614, "demo-subsystem-with-monitoring/main", 1.0f, 0.5f);
            this.placeValve(0.3137, 0.8586, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", 1.0f, 0.5f);
            this.placeMa(0.5351, 0.1655, this.VHX_UTT_PIP_04, 0.0f, 0.5f);
            this.placeMa(0.3124, 0.3946, this.VCR_UTT_PIP_00_thru_05, 0.0f, 0.5f);
            this.placeMa(0.5166, 0.6393, this.VHX_UTT_PIP_03, 0.0f, 0.5f);
            this.placeMa(0.4096, 0.7624, this.VCR_UTT_PIP_04, 0.5f, 0.0f);
            this.placeRpm(0.5879, 0.3585, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1");
            this.placeRpm(0.5855, 0.5203, "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.view;
    }

    private void placeGauge(double x, double y, String ch) throws IOException {
        DefaultMonitorCell c = new DefaultMonitorCell(new DisplayChannelSingle(ch, null, null), this.gaugeField);
        CellTableView table = new CellTableView(1, 1, c);
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(0.5, 0.5);
        item.setMaxSize(0.085, 0.055);
        this.view.add(item);
    }

    private void placeValve(double x, double y, String ch, float horAlign, float vertAlign) throws IOException {
        DefaultMonitorCell c = new DefaultMonitorCell(new DisplayChannelSingle(ch, null, null), this.valveField);
        CellTableView table = new CellTableView(1, 1, c);
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(horAlign, vertAlign);
        item.setMaxSize(0.242, 0.082);
        this.view.add(item);
    }

    private void placeMa(double x, double y, String[] ch, float horAlign, float vertAlign) throws IOException {
        DefaultMonitorCell c0 = new DefaultMonitorCell(new DisplayChannelSingle(ch[0], null, null), this.maField);
        DefaultMonitorCell c1 = new DefaultMonitorCell(new DisplayChannelSingle(ch[1], null, null), this.lsField);
        CellTableView table = new CellTableView(2, 1, c0, c1);
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(horAlign, vertAlign);
        item.setMaxSize(0.242, 0.082);
        this.view.add(item);
    }

    private void placeRpm(double x, double y, String ch) throws IOException {
        DefaultMonitorCell c = new DefaultMonitorCell(new DisplayChannelSingle(ch, null, null), this.rpmField);
        CellTableView table = new CellTableView(1, 1, c);
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(0.0, 0.5);
        item.setMaxSize(0.1132, 0.0382);
        this.view.add(item);
    }

    public static void main(String ... a) {
        System.out.println(String.format("%1$6.1e%nss", 3.9999));
    }
}

