/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCommand;
import org.apache.commons.jcs3.auxiliary.lateral.LateralElementDescriptor;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPSender;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.CacheInfo;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class LateralTCPService<K, V>
implements ICacheServiceNonLocal<K, V> {
    private static final Log log = LogManager.getLog(LateralTCPService.class);
    private final boolean allowPut;
    private final boolean allowGet;
    private final boolean issueRemoveOnPut;
    private LateralTCPSender sender;
    private long listenerId = CacheInfo.listenerId;

    public LateralTCPService(ITCPLateralCacheAttributes lca) throws IOException {
        this.allowGet = lca.isAllowGet();
        this.allowPut = lca.isAllowPut();
        this.issueRemoveOnPut = lca.isIssueRemoveOnPut();
        try {
            this.sender = new LateralTCPSender(lca);
            log.debug("Created sender to [{0}]", () -> lca.getTcpServer());
        }
        catch (IOException e) {
            log.error("Could not create sender to [{0}] -- {1}", lca.getTcpServer(), e.getMessage());
            throw e;
        }
    }

    @Override
    public void update(ICacheElement<K, V> item) throws IOException {
        this.update(item, this.getListenerId());
    }

    @Override
    public void update(ICacheElement<K, V> item, long requesterId) throws IOException {
        if (!this.allowPut && !this.issueRemoveOnPut) {
            return;
        }
        if (!this.issueRemoveOnPut) {
            LateralElementDescriptor<K, V> led = new LateralElementDescriptor<K, V>(item);
            led.requesterId = requesterId;
            led.command = LateralCommand.UPDATE;
            this.sender.send(led);
        } else {
            log.debug("Issuing a remove for a put");
            CacheElement<K, Object> ce = new CacheElement<K, Object>(item.getCacheName(), item.getKey(), null);
            LateralElementDescriptor<K, Object> led = new LateralElementDescriptor<K, Object>(ce);
            led.requesterId = requesterId;
            led.command = LateralCommand.REMOVE;
            led.valHashCode = item.getVal().hashCode();
            this.sender.send(led);
        }
    }

    @Override
    public void remove(String cacheName, K key) throws IOException {
        this.remove(cacheName, key, this.getListenerId());
    }

    @Override
    public void remove(String cacheName, K key, long requesterId) throws IOException {
        CacheElement<K, Object> ce = new CacheElement<K, Object>(cacheName, key, null);
        LateralElementDescriptor<K, Object> led = new LateralElementDescriptor<K, Object>(ce);
        led.requesterId = requesterId;
        led.command = LateralCommand.REMOVE;
        this.sender.send(led);
    }

    @Override
    public void release() throws IOException {
    }

    @Override
    public void dispose(String cacheName) throws IOException {
        this.sender.dispose();
    }

    @Override
    public ICacheElement<K, V> get(String cacheName, K key) throws IOException {
        return this.get(cacheName, key, this.getListenerId());
    }

    @Override
    public ICacheElement<K, V> get(String cacheName, K key, long requesterId) throws IOException {
        if (this.allowGet) {
            CacheElement<K, Object> ce = new CacheElement<K, Object>(cacheName, key, null);
            LateralElementDescriptor<K, Object> led = new LateralElementDescriptor<K, Object>(ce);
            led.command = LateralCommand.GET;
            ICacheElement response = (ICacheElement)this.sender.sendAndReceive(led);
            if (response != null) {
                return response;
            }
            return null;
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern) throws IOException {
        return this.getMatching(cacheName, pattern, this.getListenerId());
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        if (this.allowGet) {
            CacheElement<String, Object> ce = new CacheElement<String, Object>(cacheName, pattern, null);
            LateralElementDescriptor<String, Object> led = new LateralElementDescriptor<String, Object>(ce);
            led.command = LateralCommand.GET_MATCHING;
            Object response = this.sender.sendAndReceive(led);
            if (response != null) {
                return (Map)response;
            }
            return Collections.emptyMap();
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys) throws IOException {
        return this.getMultiple(cacheName, keys, this.getListenerId());
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys, long requesterId) throws IOException {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        if (keys != null && !keys.isEmpty()) {
            for (K key : keys) {
                ICacheElement<K, V> element = this.get(cacheName, key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    @Override
    public Set<K> getKeySet(String cacheName) throws IOException {
        CacheElement<Object, Object> ce = new CacheElement<Object, Object>(cacheName, null, null);
        LateralElementDescriptor<Object, Object> led = new LateralElementDescriptor<Object, Object>(ce);
        led.command = LateralCommand.GET_KEYSET;
        Object response = this.sender.sendAndReceive(led);
        if (response != null) {
            return (Set)response;
        }
        return null;
    }

    @Override
    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, this.getListenerId());
    }

    @Override
    public void removeAll(String cacheName, long requesterId) throws IOException {
        CacheElement<String, Object> ce = new CacheElement<String, Object>(cacheName, "ALL", null);
        LateralElementDescriptor<String, Object> led = new LateralElementDescriptor<String, Object>(ce);
        led.requesterId = requesterId;
        led.command = LateralCommand.REMOVEALL;
        this.sender.send(led);
    }

    public static void main(String[] args) {
        try {
            LateralTCPSender sender = new LateralTCPSender(new TCPLateralCacheAttributes());
            boolean notDone = true;
            String message = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            while (notDone) {
                System.out.println("enter message:");
                message = br.readLine();
                if (message == null) {
                    notDone = false;
                    continue;
                }
                CacheElement<String, String> ce = new CacheElement<String, String>("test", "test", message);
                LateralElementDescriptor<String, String> led = new LateralElementDescriptor<String, String>(ce);
                sender.send(led);
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    protected void setListenerId(long listernId) {
        this.listenerId = listernId;
    }

    protected long getListenerId() {
        return this.listenerId;
    }
}

