/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;
import org.freehep.jas.plugin.tree.DefaultFTree;
import org.freehep.jas.plugin.tree.DefaultFTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeCommands;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeSelectionManager;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.commanddispatcher.CommandProcessor;

class DefaultJTree
extends JTree
implements HasPopupItems {
    private DefaultFTree model;
    private TreePath rootTreePath;
    private CommandProcessor commandProcessor;
    private DefaultFTreeNode[] selectedNodes = null;
    private FTreeSelectionManager selectionManager;

    DefaultJTree(DefaultFTree model) {
        super(model);
        this.model = model;
        model.setJTree(this);
        this.selectionManager = new FTreeSelectionManager(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.rootTreePath = new TreePath(model.getRoot());
        this.setEditable(true);
        this.setShowsRootHandles(true);
        this.commandProcessor = new FTreeNodeCommands(this);
    }

    public CommandProcessor commandProcessor() {
        return this.commandProcessor;
    }

    DefaultFTreeNode[] selectedNodes() {
        return this.selectedNodes;
    }

    void setSelectedNodes(DefaultFTreeNode[] selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    FTreeSelectionManager selectionManager() {
        return this.selectionManager;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TreePath path = this.getClosestPathForLocation(event.getX(), event.getY());
        Rectangle r = this.getPathBounds(path);
        if (r != null && r.contains(event.getPoint())) {
            return ((DefaultFTreeNode)path.getLastPathComponent()).toolTipMessage();
        }
        return null;
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        TreePath path = this.getClosestPathForLocation(p.x, p.y);
        if (this.getPathBounds(path) == null) {
            return menu;
        }
        if (this.getPathBounds(path).contains(p)) {
            if (!this.isPathSelected(path)) {
                this.removeSelectionPaths(this.getSelectionPaths());
                this.addSelectionPath(path);
            }
            menu = this.model().adapterManager().modifyPopupMenu(this.selectedNodes(), menu);
        }
        return menu;
    }

    void setExpandedState(String path) {
        this.setExpandedState(path, false);
    }

    void setExpandedState(String path, boolean select) {
        StringTokenizer st = new StringTokenizer(path, "/");
        TreePath treePath = new TreePath(this.model().getRoot());
        FTreePath mTreePath = null;
        DefaultFTreeNode node = null;
        while (st.hasMoreTokens()) {
            mTreePath = mTreePath == null ? new FTreePath(st.nextToken()) : mTreePath.pathByAddingChild(st.nextToken());
            node = (DefaultFTreeNode)this.model().findNode(mTreePath);
            if (node != null) {
                node.getChildCount();
                treePath = treePath.pathByAddingChild(node);
            }
            if (!st.hasMoreTokens()) continue;
            this.expandRow(this.getRowForPath(treePath));
        }
        int row = this.getRowForPath(treePath);
        if (select) {
            this.setSelectionRow(row);
        } else {
            this.expandRow(row);
        }
    }

    DefaultFTree model() {
        return this.model;
    }
}

