/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.swing;

import java.awt.Dimension;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;

public final class DurationSelector
extends JPanel {
    private static final ChronoUnit[] defaultUnits = new ChronoUnit[]{ChronoUnit.MONTHS, ChronoUnit.WEEKS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS};
    private final SpinnerNumberModel amountModel;
    private final JSpinner amountSpinner;
    private final JComboBox unitCombo;
    private final ChronoUnit[] units;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();
    private boolean notMuted = true;

    public DurationSelector(int amount, ChronoUnit unit, ChronoUnit ... units) {
        this.setLayout(new BoxLayout(this, 0));
        this.units = units.length == 0 ? defaultUnits : units;
        this.amountModel = new SpinnerNumberModel(amount, 1, Integer.MAX_VALUE, 1);
        this.amountSpinner = new JSpinner(this.amountModel);
        try {
            JFormattedTextField tf = ((JSpinner.DefaultEditor)this.amountSpinner.getEditor()).getTextField();
            tf.setColumns(10);
            NumberFormatter f = (NumberFormatter)tf.getFormatter();
            f.setCommitsOnValidEdit(true);
            f.setAllowsInvalid(false);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.amountSpinner.addChangeListener(e -> this.fire());
        this.add(this.amountSpinner);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.unitCombo = new JComboBox<ChronoUnit>(units);
        this.unitCombo.setMaximumSize(this.unitCombo.getPreferredSize());
        this.unitCombo.addActionListener(e -> this.fire());
        this.add(this.unitCombo);
        this.setMaximumSize(this.getPreferredSize());
        this.setAlignmentX(0.0f);
    }

    public DurationSelector(int amount, ChronoUnit unit) {
        this(amount, unit, defaultUnits);
    }

    public DurationSelector() {
        this(1, ChronoUnit.DAYS, defaultUnits);
    }

    public void setAmountLimits(int min, int max) {
        this.amountModel.setMinimum(Integer.valueOf(min));
        this.amountModel.setMaximum(Integer.valueOf(max));
    }

    public long get() {
        return this.getUnit().getDuration().multipliedBy(this.getAmount()).getSeconds();
    }

    public int getAmount() {
        return (Integer)this.amountModel.getNumber();
    }

    public ChronoUnit getUnit() {
        return (ChronoUnit)this.unitCombo.getSelectedItem();
    }

    public void set(long seconds) {
        if (seconds < 1L) {
            seconds = 1L;
        }
        long am = 0L;
        ChronoUnit un = this.units[0];
        for (ChronoUnit u : this.units) {
            long s = u.getDuration().getSeconds();
            long a = seconds / s;
            if (seconds % s == 0L) {
                am = a;
                un = u;
                break;
            }
            if (a > Integer.MAX_VALUE) break;
        }
        this.notMuted = false;
        this.amountModel.setValue((int)am);
        this.unitCombo.setSelectedItem(un);
        this.notMuted = true;
    }

    public void set(int amount, ChronoUnit unit) {
        if (amount < 1) {
            amount = 1;
        }
        int index = -1;
        for (int i = 0; i < this.units.length; ++i) {
            if (!this.units[i].equals(unit)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            this.set(unit.getDuration().multipliedBy(amount).getSeconds());
        } else {
            this.notMuted = false;
            this.amountModel.setValue(amount);
            this.unitCombo.setSelectedIndex(index);
            this.notMuted = true;
        }
    }

    public void setRounded(long seconds) {
        for (ChronoUnit u : this.units) {
            long s = seconds / u.getDuration().getSeconds();
            if (s <= 0L) continue;
            this.set((int)s, u);
            return;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.amountSpinner.setEnabled(enabled);
        this.unitCombo.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.amountSpinner.setToolTipText(text);
        this.unitCombo.setToolTipText(text);
    }

    public void addListener(Listener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void fire() {
        if (this.notMuted) {
            this.listeners.forEach(listener -> listener.changed(this));
        }
    }

    public static interface Listener {
        public void changed(DurationSelector var1);
    }
}

