/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;
import org.lsst.ccs.bootstrap.ResourcesUtils;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;

class BootstrapUtils {
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final String PATH_SEPARATOR = System.getProperty("path.separator");
    protected static final String DIRECTORY_SEPARATOR = "|";
    protected static final String DISTRIBUTION_JARS_DIRECTORY = "share" + FILE_SEPARATOR + "java" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_RESOURCES_DIRECTORY = "etc" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_LIB_DIRECTORY = "lib" + (System.getProperty("sun.arch.data.model").equals("32") ? "" : System.getProperty("sun.arch.data.model")) + FILE_SEPARATOR;
    private static final String DISTRIBUTION_JNI_DIRECTORY = DISTRIBUTION_LIB_DIRECTORY + "jni" + FILE_SEPARATOR;
    static final String APPLICATION_MAINCLASS_PROPERTY = "org.lsst.ccs.application.mainClass";
    static final String APPLICATION_EXTENDS_PROPERTY = "org.lsst.ccs.application.extends";
    static final String OBSOLETE_MAINJAR_PROPERTY = "org.lsst.ccs.application.mainJar";
    private static volatile List<String> listOfApplications = null;
    private static final Pattern extRes_pattern = Pattern.compile("(?<scheme>[a-zA-Z]+://)?(?<resource>.*?)(?<extensions>\\[(?<list>.*)\\])?");
    private static final String envVar_str_pattern = ".*(\\$\\[env\\.(.*)\\]).*";
    private static final Pattern envVar_pattern = Pattern.compile(".*(\\$\\[env\\.(.*)\\]).*");
    private static final String CCS_RESOURCE_PATH_ENV_VAR = "CCS_RESOURCE_PATH";
    private static final String CCS_DISTRIBUTION_PATH_ENV_VAR = "CCS_DISTRIBUTION_PATH";
    private static volatile String ccsDistributionRootDirectory = null;
    private static volatile ResourcesTree resourcesTree = null;
    private static final Logger LOG = Logger.getLogger(BootstrapUtils.class.getName());
    static final Map<String, ExternalResourceDirectory> externalDirs = new HashMap<String, ExternalResourceDirectory>();

    BootstrapUtils() {
    }

    protected static void reset() {
        resourcesTree = null;
        ccsDistributionRootDirectory = null;
        listOfApplications = null;
    }

    static synchronized ResourcesTree getBootstrapResourcesTree() {
        if (resourcesTree == null) {
            resourcesTree = new ResourcesTree();
            List<String> resourceDirectories = BootstrapUtils.getOrderedListOfResourceDirectories();
            List<String> additionalResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(BootstrapUtils.getUserProvidedResourceDirectories(), null, true);
            for (String resourceDirectory : resourceDirectories) {
                try {
                    ExternalResourceDirectory exDir;
                    URI uri;
                    Path dirPath;
                    String resourceURI = resourceDirectory;
                    if (!resourceURI.contains(":")) {
                        resourceURI = "file://" + resourceDirectory;
                    }
                    if (!Files.exists(dirPath = Paths.get(uri = (exDir = BootstrapUtils.getExternalResourceDir(resourceURI)).getURI()), new LinkOption[0])) continue;
                    if (additionalResourceDirectories.contains(resourceDirectory)) {
                        resourcesTree.addUserResourceDirectory(uri, exDir.getExtensionsSet());
                        continue;
                    }
                    resourcesTree.addDistributionResourceDirectory(uri, exDir.getExtensionsSet());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }
        return resourcesTree;
    }

    public static ExternalResourceDirectory getExternalResourceDir(String resourceURI) {
        return BootstrapUtils.getExternalResourceDir(resourceURI, null, null);
    }

    public static ExternalResourceDirectory getExternalResourceDir(String resourceURI, String root, String appendDirectory) {
        ExternalResourceDirectory e = externalDirs.get(resourceURI);
        if (e == null) {
            e = new ExternalResourceDirectory(resourceURI, root, appendDirectory);
            externalDirs.put(resourceURI, e);
            externalDirs.put(e.getDefinition(), e);
        }
        return e;
    }

    static String getUserProvidedResourceDirectories() {
        String resourceProperty = "org.lsst." + CCS_RESOURCE_PATH_ENV_VAR.replace("_", ".").toLowerCase();
        String userProvidedResourceDirectories = System.getProperty(resourceProperty);
        return userProvidedResourceDirectories == null ? System.getenv(CCS_RESOURCE_PATH_ENV_VAR) : userProvidedResourceDirectories;
    }

    static String getUserProvidedDistributionDirectories() {
        String distributionProperty = "org.lsst." + CCS_DISTRIBUTION_PATH_ENV_VAR.replace("_", ".").toLowerCase();
        String userProvidedDistributionDirectories = System.getProperty(distributionProperty);
        return userProvidedDistributionDirectories == null ? System.getenv(CCS_DISTRIBUTION_PATH_ENV_VAR) : userProvidedDistributionDirectories;
    }

    static List<String> getOrderedListOfResourceDirectories() {
        String userProvidedResourceDirs = BootstrapUtils.getUserProvidedResourceDirectories();
        String userProvidedDistributionDirs = BootstrapUtils.getUserProvidedDistributionDirectories();
        return BootstrapUtils.getOrderedListOfResourceDirectories(userProvidedResourceDirs, userProvidedDistributionDirs, true);
    }

    static List<String> getOrderedListOfResourceDirectories(String userProvidedResourceDirs, String userProvidedDistributions, boolean checkExistance) {
        String distributionResourceDirectoriy = BootstrapUtils.getDistributionResourcesDirectory();
        List<String> additionaDistributionResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(userProvidedDistributions, DISTRIBUTION_RESOURCES_DIRECTORY, checkExistance);
        List<String> additionalResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(userProvidedResourceDirs, null, checkExistance);
        ArrayList<String> orderedListOfResourceDirectories = new ArrayList<String>();
        for (String dir : additionalResourceDirectories) {
            orderedListOfResourceDirectories.add(dir);
        }
        if (!orderedListOfResourceDirectories.contains(distributionResourceDirectoriy)) {
            orderedListOfResourceDirectories.add(distributionResourceDirectoriy);
        }
        for (String dir : additionaDistributionResourceDirectories) {
            if (orderedListOfResourceDirectories.contains(dir)) continue;
            orderedListOfResourceDirectories.add(dir);
        }
        return orderedListOfResourceDirectories;
    }

    static List<String> extractDirectoriesFromPath(String directoryPath, String appendDirectory, boolean checkExistance) {
        return BootstrapUtils.extractDirectoriesFromPath(BootstrapUtils.getCCSDistributionRootDirectory(), directoryPath, appendDirectory, checkExistance);
    }

    static List<String> extractDirectoriesFromPath(String root, String directoryPath, String appendDirectory, boolean checkExistance) {
        ArrayList<String> extractedDirectories = new ArrayList<String>();
        if (directoryPath != null && !"".equals(directoryPath)) {
            StringTokenizer dirsToken = new StringTokenizer(directoryPath, DIRECTORY_SEPARATOR);
            while (dirsToken.hasMoreTokens()) {
                String resourceDir = dirsToken.nextToken().trim();
                ExternalResourceDirectory exDir = BootstrapUtils.getExternalResourceDir(resourceDir, root, appendDirectory);
                extractedDirectories.add(exDir.getDefinition());
            }
        }
        return extractedDirectories;
    }

    static String getDistributionResourcesDirectory() {
        return BootstrapUtils.getDistributionResourcesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionResourcesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = distribution + FILE_SEPARATOR;
        }
        return distribution + DISTRIBUTION_RESOURCES_DIRECTORY;
    }

    static String getDistributionLibDirectory() {
        return BootstrapUtils.getDistributionLibDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionLibDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = distribution + FILE_SEPARATOR;
        }
        return distribution + DISTRIBUTION_LIB_DIRECTORY;
    }

    static String getDistributionJniDirectory() {
        return BootstrapUtils.getDistributionJniDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJniDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = distribution + FILE_SEPARATOR;
        }
        return distribution + DISTRIBUTION_JNI_DIRECTORY;
    }

    static String getDistributionJarFilesDirectory() {
        return BootstrapUtils.getDistributionJarFilesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJarFilesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = distribution + FILE_SEPARATOR;
        }
        return distribution + DISTRIBUTION_JARS_DIRECTORY;
    }

    static synchronized String getCCSDistributionRootDirectory() {
        if (ccsDistributionRootDirectory == null) {
            ccsDistributionRootDirectory = BootstrapUtils.getDirectoryForClass(Bootstrap.getLoaderClass());
        }
        return ccsDistributionRootDirectory;
    }

    static String getDirectoryForClass(Class clazz) {
        String tmpCcsDistributionRootDirectory;
        block5: {
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            tmpCcsDistributionRootDirectory = "";
            try {
                Path path = Paths.get(location.toURI());
                String sourceCodeLocation = path.toString();
                if (sourceCodeLocation.endsWith(".jar")) {
                    tmpCcsDistributionRootDirectory = sourceCodeLocation.substring(0, sourceCodeLocation.lastIndexOf(FILE_SEPARATOR) + 1);
                    break block5;
                }
                if (path.toFile().isDirectory()) {
                    tmpCcsDistributionRootDirectory = sourceCodeLocation + FILE_SEPARATOR;
                    break block5;
                }
                throw new RuntimeException("Could not process souce code location " + sourceCodeLocation + " It is neither a directory nor a jar file.");
            }
            catch (URISyntaxException x) {
                throw new RuntimeException("Could not process souce code location ", x);
            }
        }
        if (tmpCcsDistributionRootDirectory.endsWith(DISTRIBUTION_JARS_DIRECTORY)) {
            tmpCcsDistributionRootDirectory = tmpCcsDistributionRootDirectory.replace(DISTRIBUTION_JARS_DIRECTORY, "");
        }
        return tmpCcsDistributionRootDirectory;
    }

    static synchronized List<String> getBootstrapListOfApplications() {
        if (listOfApplications == null) {
            listOfApplications = new ArrayList<String>();
            ArrayList<String> allPropertiesInResources = new ArrayList<String>();
            for (ResourceDirectory dir : BootstrapUtils.getBootstrapResourcesTree().getResourceDirectoryList()) {
                Path resourcePath;
                if (!dir.supportsExtension("app") && !dir.supportsExtension("properties") || !Files.exists(resourcePath = dir.getResouceDirectoryPath(), new LinkOption[0]) || !Files.isDirectory(resourcePath, new LinkOption[0])) continue;
                ArrayList files = new ArrayList();
                try {
                    Files.list(resourcePath).forEach(p -> files.add(p.getFileName().toString()));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                for (String resource : files) {
                    if (!resource.endsWith(".app")) continue;
                    String appName = resource.replace(".app", "");
                    allPropertiesInResources.add(appName);
                }
            }
            for (String propertyFile : allPropertiesInResources) {
                Properties props = ResourcesUtils.getApplicationDefinitionFile(BootstrapUtils.getBootstrapResourcesTree(), propertyFile);
                String mainClass = props.getProperty(APPLICATION_MAINCLASS_PROPERTY, "");
                String extendsApp = props.getProperty(APPLICATION_EXTENDS_PROPERTY, "");
                String applicationName = propertyFile.replace(".app", "");
                if (mainClass.isEmpty() && extendsApp.isEmpty() || listOfApplications.contains(applicationName)) continue;
                listOfApplications.add(applicationName);
            }
        }
        return listOfApplications;
    }

    static Properties getApplicationDefinitionProperties(String application) {
        String oldAppName = Bootstrap.getBootstrapApplication();
        Bootstrap.setBootstrapApplication(application);
        Properties p = BootstrapResourceUtils.getBootstrapProperties(application);
        Properties res = new Properties();
        for (String key : p.stringPropertyNames()) {
            String value = p.getProperty(key);
            res.put(key, SubstitutionTokenUtils.resolveSubstitutionTokens(value));
        }
        Bootstrap.setBootstrapApplication(oldAppName);
        return res;
    }

    static String parseProperty(String inputProperty) {
        String outProperty = inputProperty;
        Matcher m = envVar_pattern.matcher(outProperty);
        if (m.matches()) {
            String envVarValue = System.getenv(m.group(2));
            if (envVarValue != null) {
                outProperty = outProperty.replace(m.group(1), envVarValue);
            } else if (Bootstrap.isBootstrapEnvironment()) {
                System.err.println("[WARNING] Environment variable " + m.group(2) + " is not defined.");
            }
        }
        return outProperty;
    }

    static class ExternalResourceDirectory {
        private final String scheme;
        private final String resource;
        private final String extensions;
        private final String definition;
        private final Set<String> extList = new HashSet<String>();
        private URI uri;

        ExternalResourceDirectory(String directoryStr, String root, String appendDirectory) {
            Matcher m = extRes_pattern.matcher(directoryStr);
            if (!m.matches()) {
                throw new RuntimeException("Illegal external resource " + directoryStr);
            }
            this.scheme = m.group("scheme");
            this.resource = m.group("resource");
            this.extensions = m.group("extensions");
            if (this.extensions != null) {
                String[] extArray;
                String tmpExt = this.extensions.replace("[", "").replace("]", "");
                for (String e : extArray = tmpExt.split(",")) {
                    this.extList.add(e.replace(".", ""));
                }
                directoryStr = directoryStr.replace(this.extensions, "");
            }
            if (!directoryStr.endsWith(FILE_SEPARATOR)) {
                directoryStr = directoryStr + FILE_SEPARATOR;
            }
            if (this.scheme == null || "file://".equals(this.scheme)) {
                if (appendDirectory != null && !"".equals(appendDirectory)) {
                    if (!appendDirectory.endsWith(FILE_SEPARATOR)) {
                        appendDirectory = appendDirectory + FILE_SEPARATOR;
                    }
                    directoryStr = directoryStr + appendDirectory;
                }
                directoryStr = directoryStr.replace("~", System.getProperty("user.home"));
                if (root != null) {
                    Path p = Paths.get(root, new String[0]);
                    directoryStr = p.resolve(directoryStr).normalize().toString();
                }
                if (!directoryStr.endsWith(FILE_SEPARATOR)) {
                    directoryStr = directoryStr + FILE_SEPARATOR;
                }
            }
            this.definition = directoryStr;
            try {
                this.uri = new URI(this.definition);
            }
            catch (Exception e) {
                try {
                    File f = new File(this.definition);
                    this.uri = f.toURI();
                }
                catch (Exception e1) {
                    e.printStackTrace();
                }
            }
        }

        String getScheme() {
            return this.scheme;
        }

        String getResource() {
            return this.resource;
        }

        String getExtensions() {
            return this.extensions;
        }

        String getDefinition() {
            return this.definition;
        }

        Set<String> getExtensionsSet() {
            return this.extList;
        }

        URI getURI() {
            return this.uri;
        }
    }
}

